/*
 * Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.nfc;


/**
 * Represents a single available Nfc antenna
 * on an Android device.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AvailableNfcAntenna implements android.os.Parcelable {

public AvailableNfcAntenna(int locationX, int locationY) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the specified AvailableNfcAntenna contains
 * identical specifications.

 * @param obj This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object obj) { throw new RuntimeException("Stub!"); }

/**
 * Location of the antenna on the X axis in millimeters.
 * 0 is the top-left when the user is facing the screen
 * and the device orientation is Portrait.
 */

public int getLocationX() { throw new RuntimeException("Stub!"); }

/**
 * Location of the antenna on the Y axis in millimeters.
 * 0 is the top-left when the user is facing the screen
 * and the device orientation is Portrait.
 */

public int getLocationY() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.nfc.AvailableNfcAntenna> CREATOR;
static { CREATOR = null; }
}

