/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.nfc.cardemulation;

import android.content.ComponentName;
import android.os.Bundle;
import java.util.List;

/**
 * Polling Frames represent data about individual frames of an NFC polling loop. These frames will
 * be delivered to subclasses of {@link android.nfc.cardemulation.HostApduService HostApduService} that have registered filters with
 * {@link android.nfc.cardemulation.CardEmulation#registerPollingLoopFilterForService(android.content.ComponentName,java.lang.String,boolean) CardEmulation.registerPollingLoopFilterForService(ComponentName, String, boolean)} that
 * match a given frame in a loop and will be delivered through calls to
 * {@link android.nfc.cardemulation.HostApduService#processPollingFrames(java.util.List) HostApduService.processPollingFrames(List)}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PollingFrame implements android.os.Parcelable {

PollingFrame() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Returns the raw data from the polling type frame.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public byte[] getData() { throw new RuntimeException("Stub!"); }

/**
 * Returns the timestamp of when the polling loop frame was observed, in microseconds. These
 * timestamps are relative and should only be used for comparing the timing of frames relative
 * to each other.
 * @return the timestamp in microseconds
 */

public long getTimestamp() { throw new RuntimeException("Stub!"); }

/**
 * Returns whether this frame triggered the device to automatically disable observe mode and
 * allow one transaction.
 */

public boolean getTriggeredAutoTransact() { throw new RuntimeException("Stub!"); }

/**
 * Returns the type of frame for this polling loop frame.
 * The possible return values are:
 * <ul>
 *   <li>{@link #POLLING_LOOP_TYPE_ON}</li>
 *   <li>{@link #POLLING_LOOP_TYPE_OFF}</li>
 *   <li>{@link #POLLING_LOOP_TYPE_A}</li>
 *   <li>{@link #POLLING_LOOP_TYPE_B}</li>
 *   <li>{@link #POLLING_LOOP_TYPE_F}</li>
 * </ul>

 * @return Value is {@link android.nfc.cardemulation.PollingFrame#POLLING_LOOP_TYPE_A}, {@link android.nfc.cardemulation.PollingFrame#POLLING_LOOP_TYPE_B}, {@link android.nfc.cardemulation.PollingFrame#POLLING_LOOP_TYPE_F}, {@link android.nfc.cardemulation.PollingFrame#POLLING_LOOP_TYPE_OFF}, {@link android.nfc.cardemulation.PollingFrame#POLLING_LOOP_TYPE_ON}, or {@link android.nfc.cardemulation.PollingFrame#POLLING_LOOP_TYPE_UNKNOWN}
 */

public int getType() { throw new RuntimeException("Stub!"); }

/**
 * Returns the gain representing the field strength of the NFC field when this polling loop
 * frame was observed.
 * @return the gain or -1 if there is no gain measurement associated with this frame.
 */

public int getVendorSpecificGain() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.nfc.cardemulation.PollingFrame> CREATOR;
static { CREATOR = null; }

/**
 * POLLING_LOOP_TYPE_A is the value associated with the key
 * POLLING_LOOP_TYPE  in the Bundle passed to {@link android.nfc.cardemulation.HostApduService#processPollingFrames(java.util.List) HostApduService.processPollingFrames(List)}
 * when the polling loop is for NFC-A.
 */

public static final int POLLING_LOOP_TYPE_A = 65; // 0x41

/**
 * POLLING_LOOP_TYPE_B is the value associated with the key
 * POLLING_LOOP_TYPE  in the Bundle passed to {@link android.nfc.cardemulation.HostApduService#processPollingFrames(java.util.List) HostApduService.processPollingFrames(List)}
 * when the polling loop is for NFC-B.
 */

public static final int POLLING_LOOP_TYPE_B = 66; // 0x42

/**
 * POLLING_LOOP_TYPE_F is the value associated with the key
 * POLLING_LOOP_TYPE  in the Bundle passed to {@link android.nfc.cardemulation.HostApduService#processPollingFrames(java.util.List) HostApduService.processPollingFrames(List)}
 * when the polling loop is for NFC-F.
 */

public static final int POLLING_LOOP_TYPE_F = 70; // 0x46

/**
 * POLLING_LOOP_TYPE_OFF is the value associated with the key
 * POLLING_LOOP_TYPE  in the Bundle passed to {@link android.nfc.cardemulation.HostApduService#processPollingFrames(java.util.List) HostApduService.processPollingFrames(List)}
 * when the polling loop turns off.
 */

public static final int POLLING_LOOP_TYPE_OFF = 88; // 0x58

/**
 * POLLING_LOOP_TYPE_ON is the value associated with the key
 * POLLING_LOOP_TYPE  in the Bundle passed to {@link android.nfc.cardemulation.HostApduService#processPollingFrames(java.util.List) HostApduService.processPollingFrames(List)}
 * when the polling loop turns on.
 */

public static final int POLLING_LOOP_TYPE_ON = 79; // 0x4f

/**
 * POLLING_LOOP_TYPE_UNKNOWN is the value associated with the key
 * POLLING_LOOP_TYPE  in the Bundle passed to {@link android.nfc.cardemulation.HostApduService#processPollingFrames(java.util.List) HostApduService.processPollingFrames(List)}
 * when the polling loop frame isn't recognized.
 */

public static final int POLLING_LOOP_TYPE_UNKNOWN = 85; // 0x55
}

