/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.os;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class VibrationEffect implements android.os.Parcelable {

VibrationEffect() { throw new RuntimeException("Stub!"); }

public static android.os.VibrationEffect createOneShot(long milliseconds, int amplitude) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.os.VibrationEffect createPredefined(int effectId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.os.VibrationEffect createRepeatingEffect(@android.annotation.NonNull android.os.VibrationEffect effect) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.os.VibrationEffect createRepeatingEffect(@android.annotation.NonNull android.os.VibrationEffect preamble, @android.annotation.NonNull android.os.VibrationEffect repeatingEffect) { throw new RuntimeException("Stub!"); }

public static android.os.VibrationEffect createWaveform(long[] timings, int repeat) { throw new RuntimeException("Stub!"); }

public static android.os.VibrationEffect createWaveform(long[] timings, int[] amplitudes, int repeat) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.os.VibrationEffect.Composition startComposition() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.os.VibrationEffect> CREATOR;
static { CREATOR = null; }

public static final int DEFAULT_AMPLITUDE = -1; // 0xffffffff

public static final int EFFECT_CLICK = 0; // 0x0

public static final int EFFECT_DOUBLE_CLICK = 1; // 0x1

public static final int EFFECT_HEAVY_CLICK = 5; // 0x5

public static final int EFFECT_TICK = 2; // 0x2
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class BasicEnvelopeBuilder {

public BasicEnvelopeBuilder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.VibrationEffect.BasicEnvelopeBuilder addControlPoint(float intensity, float sharpness, long durationMillis) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.VibrationEffect build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.VibrationEffect.BasicEnvelopeBuilder setInitialSharpness(float initialSharpness) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Composition {

Composition() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.VibrationEffect.Composition addPrimitive(int primitiveId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.VibrationEffect.Composition addPrimitive(int primitiveId, float scale) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.VibrationEffect.Composition addPrimitive(int primitiveId, float scale, int delay) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.VibrationEffect.Composition addPrimitive(int primitiveId, float scale, int delay, int delayType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.VibrationEffect compose() { throw new RuntimeException("Stub!"); }

public static final int DELAY_TYPE_PAUSE = 0; // 0x0

public static final int DELAY_TYPE_RELATIVE_START_OFFSET = 1; // 0x1

public static final int PRIMITIVE_CLICK = 1; // 0x1

public static final int PRIMITIVE_LOW_TICK = 8; // 0x8

public static final int PRIMITIVE_QUICK_FALL = 6; // 0x6

public static final int PRIMITIVE_QUICK_RISE = 4; // 0x4

public static final int PRIMITIVE_SLOW_RISE = 5; // 0x5

public static final int PRIMITIVE_SPIN = 3; // 0x3

public static final int PRIMITIVE_THUD = 2; // 0x2

public static final int PRIMITIVE_TICK = 7; // 0x7
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class WaveformEnvelopeBuilder {

public WaveformEnvelopeBuilder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.VibrationEffect.WaveformEnvelopeBuilder addControlPoint(float amplitude, float frequencyHz, long durationMillis) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.VibrationEffect build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.VibrationEffect.WaveformEnvelopeBuilder setInitialFrequencyHz(float initialFrequencyHz) { throw new RuntimeException("Stub!"); }
}

}

