/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging;


/**
 * Represents a ranging measurement.
 *
 * <p>This class provides a measurement result, such as a distance or angle.
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RangingMeasurement implements android.os.Parcelable {

RangingMeasurement() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Returns the confidence score for this measurement.
 *

 * @return Value is {@link android.ranging.RangingMeasurement#CONFIDENCE_LOW}, {@link android.ranging.RangingMeasurement#CONFIDENCE_MEDIUM}, or {@link android.ranging.RangingMeasurement#CONFIDENCE_HIGH}
 */

public int getConfidence() { throw new RuntimeException("Stub!"); }

/**
 * Returns the measurement value.
 *
 * @return The measurement, such as a distance in meters or an angle in degrees.
 */

public double getMeasurement() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** Ranging measurement with high confidence.
 *
 */

public static final int CONFIDENCE_HIGH = 2; // 0x2

/** Ranging measurement with low confidence.
 *
 */

public static final int CONFIDENCE_LOW = 0; // 0x0

/** Ranging measurement with medium confidence.
 *
 */

public static final int CONFIDENCE_MEDIUM = 1; // 0x1

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.RangingMeasurement> CREATOR;
static { CREATOR = null; }
}

