/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging.oob;


/**
 * Represents the configuration for an Out-of-Band (OOB) responder in a ranging session.
 * This class contains configuration and device handle information for establishing
 * a ranging session with an initiator.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class OobResponderRangingConfig extends android.ranging.RangingConfig implements android.os.Parcelable {

OobResponderRangingConfig() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Returns the DeviceHandle associated with this OOB responder.
 *
 * @return The DeviceHandle of the OOB responder.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.oob.DeviceHandle getDeviceHandle() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.oob.OobResponderRangingConfig> CREATOR;
static { CREATOR = null; }
/**
 * Builder class for creating instances of {@link android.ranging.oob.OobResponderRangingConfig OobResponderRangingConfig}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a new Builder instance with the specified DeviceHandle.
 *
 * @param deviceHandle The DeviceHandle to associate with this OOB responder.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.ranging.oob.DeviceHandle deviceHandle) { throw new RuntimeException("Stub!"); }

/**
 * Builds an instance of {@link android.ranging.oob.OobResponderRangingConfig OobResponderRangingConfig} with the provided parameters.
 *
 * @return A new OobResponderRangingParams instance.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.oob.OobResponderRangingConfig build() { throw new RuntimeException("Stub!"); }
}

}

