/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging.raw;


/**
 * Represents the configuration for a raw ranging session initiated by a responder device.
 * This class holds a {@link android.ranging.raw.RawRangingDevice} object that participates in the
 * session.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RawResponderRangingConfig extends android.ranging.RangingConfig implements android.os.Parcelable {

RawResponderRangingConfig() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Returns the {@link android.ranging.raw.RawRangingDevice} participating in this session as the
 * responder.
 *
 * @return the raw ranging device.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.raw.RawRangingDevice getRawRangingDevice() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.raw.RawResponderRangingConfig> CREATOR;
static { CREATOR = null; }
/**
 * Builder class for constructing instances of {@link RawResponderRangingParams}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Builds and returns a new {@link RawResponderRangingParams} instance.
 *
 * @return a configured instance of {@link RawResponderRangingParams}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.raw.RawResponderRangingConfig build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link android.ranging.raw.RawRangingDevice} for this responder session.
 *
 * @param rangingDevice the raw ranging device.
 * This value cannot be {@code null}.
 * @return this {@link android.ranging.raw.RawResponderRangingConfig.Builder Builder} instance.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.raw.RawResponderRangingConfig.Builder setRawRangingDevice(@android.annotation.NonNull android.ranging.raw.RawRangingDevice rangingDevice) { throw new RuntimeException("Stub!"); }
}

}

