/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging.uwb;


/**
 * A Class representing the complex channel for UWB which comprises channel and preamble index
 * negotiated between peer devices out of band before ranging.
 *
 * <p> PRF (Pulse Repetition Frequency) supported:
 * <ul>
 *     <li> BPRF - Base Pulse Repetition Frequency.</li>
 *     <li> HPRF - Higher Pulse Repetition Frequency.</li>
 * </ul>
 *
 * See <a href="https://groups.firaconsortium.org/wg/members/document/1949> FiRa UCI Spec.</a>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class UwbComplexChannel implements android.os.Parcelable {

UwbComplexChannel() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Gets the UWB channel associated with this configuration.
 *
 * @return The channel number, which is one of the predefined UWB channels:

 * Value is {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_5}, {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_6}, {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_8}, {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_9}, {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_10}, {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_12}, {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_13}, or {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_14}
 */

public int getChannel() { throw new RuntimeException("Stub!"); }

/**
 * Gets the UWB preamble index associated with this configuration.
 *
 * @return The preamble index, which is one of the predefined UWB preamble indices:
 *
 * See <a href="https://groups.firaconsortium.org/wg/members/document/1949> FiRa UCI Spec.</a>

 * Value is {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_9}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_10}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_11}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_12}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_25}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_26}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_27}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_28}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_29}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_30}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_31}, or {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_32}
 */

public int getPreambleIndex() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.uwb.UwbComplexChannel> CREATOR;
static { CREATOR = null; }

/** UWB channel 10 */

public static final int UWB_CHANNEL_10 = 10; // 0xa

/** UWB channel 12 */

public static final int UWB_CHANNEL_12 = 12; // 0xc

/** UWB channel 13 */

public static final int UWB_CHANNEL_13 = 13; // 0xd

/** UWB channel 14 */

public static final int UWB_CHANNEL_14 = 14; // 0xe

/** UWB channel 5 */

public static final int UWB_CHANNEL_5 = 5; // 0x5

/** UWB channel 6 */

public static final int UWB_CHANNEL_6 = 6; // 0x6

/** UWB channel 8 */

public static final int UWB_CHANNEL_8 = 8; // 0x8

/** UWB channel 9 */

public static final int UWB_CHANNEL_9 = 9; // 0x9

/** UWB preamble code index 10 (PRF mode - BPRF). */

public static final int UWB_PREAMBLE_CODE_INDEX_10 = 10; // 0xa

/** UWB preamble code index 11 (PRF mode - BPRF). */

public static final int UWB_PREAMBLE_CODE_INDEX_11 = 11; // 0xb

/** UWB preamble code index 12 (PRF mode - BPRF). */

public static final int UWB_PREAMBLE_CODE_INDEX_12 = 12; // 0xc

/** UWB preamble code index 25 (PRF mode - HPRF). */

public static final int UWB_PREAMBLE_CODE_INDEX_25 = 25; // 0x19

/** UWB preamble code index 26 (PRF mode - HPRF). */

public static final int UWB_PREAMBLE_CODE_INDEX_26 = 26; // 0x1a

/** UWB preamble code index 27 (PRF mode - HPRF). */

public static final int UWB_PREAMBLE_CODE_INDEX_27 = 27; // 0x1b

/** UWB preamble code index 28 (PRF mode - HPRF). */

public static final int UWB_PREAMBLE_CODE_INDEX_28 = 28; // 0x1c

/** UWB preamble code index 29 (PRF mode - HPRF). */

public static final int UWB_PREAMBLE_CODE_INDEX_29 = 29; // 0x1d

/** UWB preamble code index 30 (PRF mode - HPRF). */

public static final int UWB_PREAMBLE_CODE_INDEX_30 = 30; // 0x1e

/** UWB preamble code index 31 (PRF mode - HPRF). */

public static final int UWB_PREAMBLE_CODE_INDEX_31 = 31; // 0x1f

/** UWB preamble code index 32 (PRF mode - HPRF). */

public static final int UWB_PREAMBLE_CODE_INDEX_32 = 32; // 0x20

/** UWB preamble code index 9 (PRF mode - BPRF). */

public static final int UWB_PREAMBLE_CODE_INDEX_9 = 9; // 0x9
/**
 * Builder for creating instances of {@link android.ranging.uwb.UwbComplexChannel UwbComplexChannel}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Builds and returns a new instance of {@link android.ranging.uwb.UwbComplexChannel UwbComplexChannel}.
 *
 * @return A new {@link android.ranging.uwb.UwbComplexChannel UwbComplexChannel} instance.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.uwb.UwbComplexChannel build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the channel for the ranging device.
 * <p> Defaults to {@link #UWB_CHANNEL_5}
 *
 * @param channel The channel number to be set.
 * Value is {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_5}, {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_6}, {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_8}, {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_9}, {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_10}, {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_12}, {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_13}, or {@link android.ranging.uwb.UwbComplexChannel#UWB_CHANNEL_14}
 * @return This {@link android.ranging.uwb.UwbComplexChannel.Builder Builder} instance.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.uwb.UwbComplexChannel.Builder setChannel(int channel) { throw new RuntimeException("Stub!"); }

/**
 * Sets the preamble index for the ranging device as defined in
 * See <a href="https://groups.firaconsortium.org/wg/members/document/1949> FiRa UCI
 * Spec.</a>}
 * <p> PRF (Pulse Repetition Frequency) is selected based on the preamble index set here.
 *
 * <p> Defaults to a random BPRF preamble index.
 * One among {@link #UWB_PREAMBLE_CODE_INDEX_9}, {@link #UWB_PREAMBLE_CODE_INDEX_10},
 * {@link #UWB_PREAMBLE_CODE_INDEX_11} or {@link #UWB_PREAMBLE_CODE_INDEX_12}.
 * For better performance always use a random preamble index for each ranging session.
 *
 * @param preambleIndex The preamble index to be set.
 * Value is {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_9}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_10}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_11}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_12}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_25}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_26}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_27}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_28}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_29}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_30}, {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_31}, or {@link android.ranging.uwb.UwbComplexChannel#UWB_PREAMBLE_CODE_INDEX_32}
 * @return This {@link android.ranging.uwb.UwbComplexChannel.Builder Builder} instance.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.uwb.UwbComplexChannel.Builder setPreambleIndex(int preambleIndex) { throw new RuntimeException("Stub!"); }
}

}

