/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging.wifi.rtt;


/**
 * Represents the capabilities of the WiFi Neighbor Awareness Networking Round Trip Time (NAN-RTT)
 * ranging.
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RttRangingCapabilities implements android.os.Parcelable {

RttRangingCapabilities() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether the hardware supports periodic ranging feature.
 *
 * @return {@code true} if periodic ranging is supported; {@code false} otherwise.
 */

public boolean hasPeriodicRangingHardwareFeature() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.wifi.rtt.RttRangingCapabilities> CREATOR;
static { CREATOR = null; }
}

