/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.ranging.wifi.rtt;

import android.ranging.raw.RawRangingDevice;
import java.util.List;

/**
 * Represents the parameters required to perform Wi-Fi Round Trip Time (RTT) ranging.
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RttRangingParams implements android.os.Parcelable {

RttRangingParams() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the match filter for this ranging session.
 *
 * @return a byte array representing the match filter.
 * This value may be {@code null}.
 * @see android.net.wifi.aware.PublishConfig.Builder#setMatchFilter(List)
 * @see android.net.wifi.aware.SubscribeConfig.Builder#setMatchFilter(List)
 */

@android.annotation.Nullable
public byte[] getMatchFilter() { throw new RuntimeException("Stub!"); }

/**
 * Returns the ranging update rate.
 *
 * @return ranging update rate.
 * <p>Possible values:
 * {@link android.ranging.raw.RawRangingDevice.RangingUpdateRate#UPDATE_RATE_NORMAL RangingUpdateRate.UPDATE_RATE_NORMAL}
 * {@link android.ranging.raw.RawRangingDevice.RangingUpdateRate#UPDATE_RATE_INFREQUENT RangingUpdateRate.UPDATE_RATE_INFREQUENT}
 * {@link android.ranging.raw.RawRangingDevice.RangingUpdateRate#UPDATE_RATE_FREQUENT RangingUpdateRate.UPDATE_RATE_FREQUENT}

 * Value is {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_NORMAL}, {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_INFREQUENT}, or {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_FREQUENT}
 */

public int getRangingUpdateRate() { throw new RuntimeException("Stub!"); }

/**
 * Returns the service name associated with this RTT ranging session.
 *
 * @return the service name as a {@link java.lang.String String}.
 * This value cannot be {@code null}.
 * @see android.net.wifi.aware.PublishConfig.Builder#setServiceName(String)
 * @see android.net.wifi.aware.SubscribeConfig.Builder#setServiceName(String)
 */

@android.annotation.NonNull
public java.lang.String getServiceName() { throw new RuntimeException("Stub!"); }

/**
 * @hide
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Returns whether the periodic ranging hardware feature was enabled.
 *
 * @return returns {@code true} if periodic ranging hardware feature was enabled, {@code false}
 * otherwise
 */

public boolean isPeriodicRangingHwFeatureEnabled() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.ranging.wifi.rtt.RttRangingParams> CREATOR;
static { CREATOR = null; }
/**
 * Builder class for {@link android.ranging.wifi.rtt.RttRangingParams RttRangingParams}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a new {@link android.ranging.wifi.rtt.RttRangingParams.Builder Builder} for creating a Wifi NAN-RTT ranging session.
 *
 * @param serviceName The service name associated with this session
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if {@code serviceName} is null.
 */

public Builder(@android.annotation.NonNull java.lang.String serviceName) { throw new RuntimeException("Stub!"); }

/**
 * Builds and returns a new {@link android.ranging.wifi.rtt.RttRangingParams RttRangingParams} instance.
 *
 * @return a new {@link android.ranging.wifi.rtt.RttRangingParams RttRangingParams} object configured with the provided parameters.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.wifi.rtt.RttRangingParams build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the match filter to identify specific devices or services for RTT.
 *
 * @param matchFilter a byte array representing the filter.
 *
 * This value cannot be {@code null}.
 * @return this {@link android.ranging.wifi.rtt.RttRangingParams.Builder Builder} instance.
 * This value cannot be {@code null}.
 * @throws java.lang.NullPointerException if either parameter is {@code matchFilter} is null.
 */

@android.annotation.NonNull
public android.ranging.wifi.rtt.RttRangingParams.Builder setMatchFilter(@android.annotation.NonNull byte[] matchFilter) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether to use hardware supported periodic ranging feature in WiFi Nan-RTT.
 *
 * @param periodicRangingHwFeatureEnabled {@code true} to enable periodic ranging;
 *                                        {@code false} otherwise.
 * @return this {@link android.ranging.wifi.rtt.RttRangingParams.Builder Builder} instance.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.wifi.rtt.RttRangingParams.Builder setPeriodicRangingHwFeatureEnabled(boolean periodicRangingHwFeatureEnabled) { throw new RuntimeException("Stub!"); }

/**
 * Sets the update rate for the RTT ranging session.
 * <p>Defaults to {@link android.ranging.raw.RawRangingDevice.RangingUpdateRate#UPDATE_RATE_NORMAL RangingUpdateRate.UPDATE_RATE_NORMAL}
 *
 * @param updateRate the reporting frequency.
 *                   <p>Possible values:
 *                   {@link android.ranging.raw.RawRangingDevice.RangingUpdateRate#UPDATE_RATE_NORMAL RangingUpdateRate.UPDATE_RATE_NORMAL}
 *                   {@link android.ranging.raw.RawRangingDevice.RangingUpdateRate#UPDATE_RATE_INFREQUENT RangingUpdateRate.UPDATE_RATE_INFREQUENT}
 *                   {@link android.ranging.raw.RawRangingDevice.RangingUpdateRate#UPDATE_RATE_FREQUENT RangingUpdateRate.UPDATE_RATE_FREQUENT}
 * Value is {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_NORMAL}, {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_INFREQUENT}, or {@link android.ranging.raw.RawRangingDevice#UPDATE_RATE_FREQUENT}
 * @return this {@link android.ranging.wifi.rtt.RttRangingParams.Builder Builder} instance.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.ranging.wifi.rtt.RttRangingParams.Builder setRangingUpdateRate(int updateRate) { throw new RuntimeException("Stub!"); }
}

}

