/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.text;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class Layout {

protected Layout(java.lang.CharSequence text, android.text.TextPaint paint, int width, android.text.Layout.Alignment align, float spacingMult, float spacingAdd) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.RectF computeDrawingBoundingBox() { throw new RuntimeException("Stub!"); }

public void draw(android.graphics.Canvas c) { throw new RuntimeException("Stub!"); }

public void draw(android.graphics.Canvas canvas, android.graphics.Path selectionHighlight, android.graphics.Paint selectionHighlightPaint, int cursorOffsetVertical) { throw new RuntimeException("Stub!"); }

public void draw(@android.annotation.NonNull android.graphics.Canvas canvas, @android.annotation.Nullable java.util.List<android.graphics.Path> highlightPaths, @android.annotation.Nullable java.util.List<android.graphics.Paint> highlightPaints, @android.annotation.Nullable android.graphics.Path selectionPath, @android.annotation.Nullable android.graphics.Paint selectionPaint, int cursorOffsetVertical) { throw new RuntimeException("Stub!"); }

public void drawBackground(@android.annotation.NonNull android.graphics.Canvas canvas) { throw new RuntimeException("Stub!"); }

public void drawText(@android.annotation.NonNull android.graphics.Canvas canvas) { throw new RuntimeException("Stub!"); }

public void fillCharacterBounds(int start, int end, @android.annotation.NonNull float[] bounds, int boundsStart) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.text.Layout.Alignment getAlignment() { throw new RuntimeException("Stub!"); }

public abstract int getBottomPadding();

public final int getBreakStrategy() { throw new RuntimeException("Stub!"); }

public void getCursorPath(int point, android.graphics.Path dest, java.lang.CharSequence editingBuffer) { throw new RuntimeException("Stub!"); }

public static float getDesiredWidth(java.lang.CharSequence source, android.text.TextPaint paint) { throw new RuntimeException("Stub!"); }

public static float getDesiredWidth(java.lang.CharSequence source, int start, int end, android.text.TextPaint paint) { throw new RuntimeException("Stub!"); }

public abstract int getEllipsisCount(int line);

public abstract int getEllipsisStart(int line);

@android.annotation.Nullable
public final android.text.TextUtils.TruncateAt getEllipsize() { throw new RuntimeException("Stub!"); }

public int getEllipsizedWidth() { throw new RuntimeException("Stub!"); }

public int getHeight() { throw new RuntimeException("Stub!"); }

public final int getHyphenationFrequency() { throw new RuntimeException("Stub!"); }

public final int getJustificationMode() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public final int[] getLeftIndents() { throw new RuntimeException("Stub!"); }

public final int getLineAscent(int line) { throw new RuntimeException("Stub!"); }

public final int getLineBaseline(int line) { throw new RuntimeException("Stub!"); }

public final int getLineBottom(int line) { throw new RuntimeException("Stub!"); }

public int getLineBottom(int line, boolean includeLineSpacing) { throw new RuntimeException("Stub!"); }

public int getLineBounds(int line, android.graphics.Rect bounds) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.text.LineBreakConfig getLineBreakConfig() { throw new RuntimeException("Stub!"); }

public abstract boolean getLineContainsTab(int line);

public abstract int getLineCount();

public abstract int getLineDescent(int line);

public abstract android.text.Layout.Directions getLineDirections(int line);

public final int getLineEnd(int line) { throw new RuntimeException("Stub!"); }

public int getLineForOffset(int offset) { throw new RuntimeException("Stub!"); }

public int getLineForVertical(int vertical) { throw new RuntimeException("Stub!"); }

public float getLineLeft(int line) { throw new RuntimeException("Stub!"); }

public int getLineLetterSpacingUnitCount(int line, boolean includeTrailingWhitespace) { throw new RuntimeException("Stub!"); }

public float getLineMax(int line) { throw new RuntimeException("Stub!"); }

public float getLineRight(int line) { throw new RuntimeException("Stub!"); }

public final float getLineSpacingAmount() { throw new RuntimeException("Stub!"); }

public final float getLineSpacingMultiplier() { throw new RuntimeException("Stub!"); }

public abstract int getLineStart(int line);

public abstract int getLineTop(int line);

public int getLineVisibleEnd(int line) { throw new RuntimeException("Stub!"); }

public float getLineWidth(int line) { throw new RuntimeException("Stub!"); }

public final int getMaxLines() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.graphics.Paint.FontMetrics getMinimumFontMetrics() { throw new RuntimeException("Stub!"); }

public int getOffsetForHorizontal(int line, float horiz) { throw new RuntimeException("Stub!"); }

public int getOffsetToLeftOf(int offset) { throw new RuntimeException("Stub!"); }

public int getOffsetToRightOf(int offset) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.text.TextPaint getPaint() { throw new RuntimeException("Stub!"); }

public final android.text.Layout.Alignment getParagraphAlignment(int line) { throw new RuntimeException("Stub!"); }

public abstract int getParagraphDirection(int line);

public final int getParagraphLeft(int line) { throw new RuntimeException("Stub!"); }

public final int getParagraphRight(int line) { throw new RuntimeException("Stub!"); }

public float getPrimaryHorizontal(int offset) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public int[] getRangeForRect(@android.annotation.NonNull android.graphics.RectF area, @android.annotation.NonNull android.text.SegmentFinder segmentFinder, @android.annotation.NonNull android.text.Layout.TextInclusionStrategy inclusionStrategy) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public final int[] getRightIndents() { throw new RuntimeException("Stub!"); }

public float getSecondaryHorizontal(int offset) { throw new RuntimeException("Stub!"); }

public void getSelectionPath(int start, int end, android.graphics.Path dest) { throw new RuntimeException("Stub!"); }

public boolean getShiftDrawingOffsetForStartOverhang() { throw new RuntimeException("Stub!"); }

public final float getSpacingAdd() { throw new RuntimeException("Stub!"); }

public final float getSpacingMultiplier() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final java.lang.CharSequence getText() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.text.TextDirectionHeuristic getTextDirectionHeuristic() { throw new RuntimeException("Stub!"); }

public abstract int getTopPadding();

public boolean getUseBoundsForWidth() { throw new RuntimeException("Stub!"); }

public final int getWidth() { throw new RuntimeException("Stub!"); }

public final void increaseWidthTo(int wid) { throw new RuntimeException("Stub!"); }

public boolean isFallbackLineSpacingEnabled() { throw new RuntimeException("Stub!"); }

public final boolean isFontPaddingIncluded() { throw new RuntimeException("Stub!"); }

public boolean isRtlCharAt(int offset) { throw new RuntimeException("Stub!"); }

protected final boolean isSpanned() { throw new RuntimeException("Stub!"); }

public static final int BREAK_STRATEGY_BALANCED = 2; // 0x2

public static final int BREAK_STRATEGY_HIGH_QUALITY = 1; // 0x1

public static final int BREAK_STRATEGY_SIMPLE = 0; // 0x0

public static final float DEFAULT_LINESPACING_ADDITION = 0.0f;

public static final float DEFAULT_LINESPACING_MULTIPLIER = 1.0f;

public static final int DIR_LEFT_TO_RIGHT = 1; // 0x1

public static final int DIR_RIGHT_TO_LEFT = -1; // 0xffffffff

public static final int HYPHENATION_FREQUENCY_FULL = 2; // 0x2

public static final int HYPHENATION_FREQUENCY_FULL_FAST = 4; // 0x4

public static final int HYPHENATION_FREQUENCY_NONE = 0; // 0x0

public static final int HYPHENATION_FREQUENCY_NORMAL = 1; // 0x1

public static final int HYPHENATION_FREQUENCY_NORMAL_FAST = 3; // 0x3

@android.annotation.NonNull public static final android.text.Layout.TextInclusionStrategy INCLUSION_STRATEGY_ANY_OVERLAP;
static { INCLUSION_STRATEGY_ANY_OVERLAP = null; }

@android.annotation.NonNull public static final android.text.Layout.TextInclusionStrategy INCLUSION_STRATEGY_CONTAINS_ALL;
static { INCLUSION_STRATEGY_CONTAINS_ALL = null; }

@android.annotation.NonNull public static final android.text.Layout.TextInclusionStrategy INCLUSION_STRATEGY_CONTAINS_CENTER;
static { INCLUSION_STRATEGY_CONTAINS_CENTER = null; }

public static final int JUSTIFICATION_MODE_INTER_CHARACTER = 2; // 0x2

public static final int JUSTIFICATION_MODE_INTER_WORD = 1; // 0x1

public static final int JUSTIFICATION_MODE_NONE = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum Alignment {
ALIGN_CENTER,
ALIGN_NORMAL,
ALIGN_OPPOSITE;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(@android.annotation.NonNull java.lang.CharSequence text, int start, int end, @android.annotation.NonNull android.text.TextPaint paint, int width) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.Layout build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.Layout.Builder setAlignment(@android.annotation.NonNull android.text.Layout.Alignment alignment) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.Layout.Builder setBreakStrategy(int breakStrategy) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.Layout.Builder setEllipsize(@android.annotation.Nullable android.text.TextUtils.TruncateAt ellipsize) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.Layout.Builder setEllipsizedWidth(int ellipsizeWidth) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.Layout.Builder setFallbackLineSpacingEnabled(boolean fallbackLineSpacing) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.Layout.Builder setFontPaddingIncluded(boolean includeFontPadding) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.Layout.Builder setHyphenationFrequency(int hyphenationFrequency) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.Layout.Builder setJustificationMode(int justificationMode) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.Layout.Builder setLeftIndents(@android.annotation.Nullable int[] leftIndents) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.Layout.Builder setLineBreakConfig(@android.annotation.NonNull android.graphics.text.LineBreakConfig lineBreakConfig) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.Layout.Builder setLineSpacingAmount(float amount) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.Layout.Builder setLineSpacingMultiplier(float multiplier) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.Layout.Builder setMaxLines(int maxLines) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.Layout.Builder setMinimumFontMetrics(@android.annotation.Nullable android.graphics.Paint.FontMetrics minimumFontMetrics) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.Layout.Builder setRightIndents(@android.annotation.Nullable int[] rightIndents) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.Layout.Builder setShiftDrawingOffsetForStartOverhang(boolean shiftDrawingOffsetForStartOverhang) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.Layout.Builder setTextDirectionHeuristic(@android.annotation.NonNull android.text.TextDirectionHeuristic textDirection) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.text.Layout.Builder setUseBoundsForWidth(boolean useBoundsForWidth) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Directions {

Directions() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@java.lang.FunctionalInterface
public static interface TextInclusionStrategy {

public boolean isSegmentInside(@android.annotation.NonNull android.graphics.RectF segmentBounds, @android.annotation.NonNull android.graphics.RectF area);
}

}

