/*
 * Copyright 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view.inspector;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface PropertyReader {

public void readBoolean(int id, boolean value);

public void readByte(int id, byte value);

public void readChar(int id, char value);

public void readColor(int id, @android.annotation.Nullable android.graphics.Color value);

public void readColor(int id, int value);

public void readColor(int id, long value);

public void readDouble(int id, double value);

public void readFloat(int id, float value);

public void readGravity(int id, int value);

public void readInt(int id, int value);

public void readIntEnum(int id, int value);

public void readIntFlag(int id, int value);

public void readLong(int id, long value);

public void readObject(int id, @android.annotation.Nullable java.lang.Object value);

public void readResourceId(int id, int value);

public void readShort(int id, short value);
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class PropertyTypeMismatchException extends java.lang.RuntimeException {

public PropertyTypeMismatchException(int id, @android.annotation.NonNull java.lang.String expectedPropertyType, @android.annotation.NonNull java.lang.String actualPropertyType) { throw new RuntimeException("Stub!"); }

public PropertyTypeMismatchException(int id, @android.annotation.NonNull java.lang.String expectedPropertyType, @android.annotation.NonNull java.lang.String actualPropertyType, @android.annotation.Nullable java.lang.String propertyName) { throw new RuntimeException("Stub!"); }
}

}

