/*
 * Copyright 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view.textclassifier;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class TextClassifierEvent implements android.os.Parcelable {

TextClassifierEvent() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public int[] getActionIndices() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String[] getEntityTypes() { throw new RuntimeException("Stub!"); }

public int getEventCategory() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.view.textclassifier.TextClassificationContext getEventContext() { throw new RuntimeException("Stub!"); }

public int getEventIndex() { throw new RuntimeException("Stub!"); }

public int getEventType() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.Bundle getExtras() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.icu.util.ULocale getLocale() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getModelName() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getResultId() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public float[] getScores() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public static final int CATEGORY_CONVERSATION_ACTIONS = 3; // 0x3

public static final int CATEGORY_LANGUAGE_DETECTION = 4; // 0x4

public static final int CATEGORY_LINKIFY = 2; // 0x2

public static final int CATEGORY_SELECTION = 1; // 0x1

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.view.textclassifier.TextClassifierEvent> CREATOR;
static { CREATOR = null; }

public static final int TYPE_ACTIONS_GENERATED = 20; // 0x14

public static final int TYPE_ACTIONS_SHOWN = 6; // 0x6

public static final int TYPE_AUTO_SELECTION = 5; // 0x5

public static final int TYPE_COPY_ACTION = 9; // 0x9

public static final int TYPE_CUT_ACTION = 11; // 0xb

public static final int TYPE_LINKS_GENERATED = 21; // 0x15

public static final int TYPE_LINK_CLICKED = 7; // 0x7

public static final int TYPE_MANUAL_REPLY = 19; // 0x13

public static final int TYPE_OTHER_ACTION = 16; // 0x10

public static final int TYPE_OVERTYPE = 8; // 0x8

public static final int TYPE_PASTE_ACTION = 10; // 0xa

public static final int TYPE_SELECTION_DESTROYED = 15; // 0xf

public static final int TYPE_SELECTION_DRAG = 14; // 0xe

public static final int TYPE_SELECTION_MODIFIED = 2; // 0x2

public static final int TYPE_SELECTION_RESET = 18; // 0x12

public static final int TYPE_SELECTION_STARTED = 1; // 0x1

public static final int TYPE_SELECT_ALL = 17; // 0x11

public static final int TYPE_SHARE_ACTION = 12; // 0xc

public static final int TYPE_SMART_ACTION = 13; // 0xd

public static final int TYPE_SMART_SELECTION_MULTI = 4; // 0x4

public static final int TYPE_SMART_SELECTION_SINGLE = 3; // 0x3
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class Builder<T extends android.view.textclassifier.TextClassifierEvent.Builder<T>> {

Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public T setActionIndices(@android.annotation.NonNull int... actionIndices) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public T setEntityTypes(@android.annotation.NonNull java.lang.String... entityTypes) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public T setEventContext(@android.annotation.Nullable android.view.textclassifier.TextClassificationContext eventContext) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public T setEventIndex(int eventIndex) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public T setExtras(@android.annotation.NonNull android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public T setLocale(@android.annotation.Nullable android.icu.util.ULocale locale) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public T setModelName(@android.annotation.Nullable java.lang.String modelVersion) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public T setResultId(@android.annotation.Nullable java.lang.String resultId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public T setScores(@android.annotation.NonNull float... scores) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class ConversationActionsEvent extends android.view.textclassifier.TextClassifierEvent implements android.os.Parcelable {

ConversationActionsEvent() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.view.textclassifier.TextClassifierEvent.ConversationActionsEvent> CREATOR;
static { CREATOR = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder extends android.view.textclassifier.TextClassifierEvent.Builder<android.view.textclassifier.TextClassifierEvent.ConversationActionsEvent.Builder> {

public Builder(int eventType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.textclassifier.TextClassifierEvent.ConversationActionsEvent build() { throw new RuntimeException("Stub!"); }
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class LanguageDetectionEvent extends android.view.textclassifier.TextClassifierEvent implements android.os.Parcelable {

LanguageDetectionEvent() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.view.textclassifier.TextClassifierEvent.LanguageDetectionEvent> CREATOR;
static { CREATOR = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder extends android.view.textclassifier.TextClassifierEvent.Builder<android.view.textclassifier.TextClassifierEvent.LanguageDetectionEvent.Builder> {

public Builder(int eventType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.textclassifier.TextClassifierEvent.LanguageDetectionEvent build() { throw new RuntimeException("Stub!"); }
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class TextLinkifyEvent extends android.view.textclassifier.TextClassifierEvent implements android.os.Parcelable {

TextLinkifyEvent() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.view.textclassifier.TextClassifierEvent.TextLinkifyEvent> CREATOR;
static { CREATOR = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder extends android.view.textclassifier.TextClassifierEvent.Builder<android.view.textclassifier.TextClassifierEvent.TextLinkifyEvent.Builder> {

public Builder(int eventType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.textclassifier.TextClassifierEvent.TextLinkifyEvent build() { throw new RuntimeException("Stub!"); }
}

}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class TextSelectionEvent extends android.view.textclassifier.TextClassifierEvent implements android.os.Parcelable {

TextSelectionEvent() { throw new RuntimeException("Stub!"); }

public int getRelativeSuggestedWordEndIndex() { throw new RuntimeException("Stub!"); }

public int getRelativeSuggestedWordStartIndex() { throw new RuntimeException("Stub!"); }

public int getRelativeWordEndIndex() { throw new RuntimeException("Stub!"); }

public int getRelativeWordStartIndex() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.view.textclassifier.TextClassifierEvent.TextSelectionEvent> CREATOR;
static { CREATOR = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder extends android.view.textclassifier.TextClassifierEvent.Builder<android.view.textclassifier.TextClassifierEvent.TextSelectionEvent.Builder> {

public Builder(int eventType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.textclassifier.TextClassifierEvent.TextSelectionEvent build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.textclassifier.TextClassifierEvent.TextSelectionEvent.Builder setRelativeSuggestedWordEndIndex(int relativeSuggestedWordEndIndex) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.textclassifier.TextClassifierEvent.TextSelectionEvent.Builder setRelativeSuggestedWordStartIndex(int relativeSuggestedWordStartIndex) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.textclassifier.TextClassifierEvent.TextSelectionEvent.Builder setRelativeWordEndIndex(int relativeWordEndIndex) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.view.textclassifier.TextClassifierEvent.TextSelectionEvent.Builder setRelativeWordStartIndex(int relativeWordStartIndex) { throw new RuntimeException("Stub!"); }
}

}

}

