/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.widget;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface ExpandableListAdapter {

public boolean areAllItemsEnabled();

public java.lang.Object getChild(int groupPosition, int childPosition);

public long getChildId(int groupPosition, int childPosition);

public android.view.View getChildView(int groupPosition, int childPosition, boolean isLastChild, android.view.View convertView, android.view.ViewGroup parent);

public int getChildrenCount(int groupPosition);

public long getCombinedChildId(long groupId, long childId);

public long getCombinedGroupId(long groupId);

public java.lang.Object getGroup(int groupPosition);

public int getGroupCount();

public long getGroupId(int groupPosition);

public android.view.View getGroupView(int groupPosition, boolean isExpanded, android.view.View convertView, android.view.ViewGroup parent);

public boolean hasStableIds();

public boolean isChildSelectable(int groupPosition, int childPosition);

public boolean isEmpty();

public void onGroupCollapsed(int groupPosition);

public void onGroupExpanded(int groupPosition);

public void registerDataSetObserver(android.database.DataSetObserver observer);

public void unregisterDataSetObserver(android.database.DataSetObserver observer);
}

