/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.widget.photopicker;


/**
 * Interface to get instance of {@link android.widget.photopicker.EmbeddedPhotoPickerProvider EmbeddedPhotoPickerProvider} class to request a new
 * {@link android.widget.photopicker.EmbeddedPhotoPickerSession EmbeddedPhotoPickerSession}.
 *
 * <p> This class creates and maintains the binding/unbinding to embedded photopicker service
 * on behalf of the caller. It makes IPC call to the service using binder
 * {@link android.widget.photopicker.IEmbeddedPhotoPicker IEmbeddedPhotoPicker} to get a new session.
 *
 * @see android.widget.photopicker.EmbeddedPhotoPickerProvider
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class EmbeddedPhotoPickerProviderFactory {

EmbeddedPhotoPickerProviderFactory() { throw new RuntimeException("Stub!"); }

/**
 * Returns an implementation of {@link android.widget.photopicker.EmbeddedPhotoPickerProvider EmbeddedPhotoPickerProvider} class.
 */

@android.annotation.NonNull
public static android.widget.photopicker.EmbeddedPhotoPickerProvider create(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }
}

