/*
 * Copyright (c) 1996, 2016, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.io;


/**
 * This class implements a character buffer that can be used as an Writer.
 * The buffer automatically grows when data is written to the stream.  The data
 * can be retrieved using toCharArray() and toString().
 * <P>
 * Note: Invoking close() on this class has no effect, and methods
 * of this class can be called after the stream has closed
 * without generating an IOException.
 *
 * @author      Herb Jellinek
 * @since       1.1
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class CharArrayWriter extends java.io.Writer {

/**
 * Creates a new CharArrayWriter.
 */

public CharArrayWriter() { throw new RuntimeException("Stub!"); }

/**
 * Creates a new CharArrayWriter with the specified initial size.
 *
 * @param initialSize  an int specifying the initial buffer size.
 * @exception java.lang.IllegalArgumentException if initialSize is negative
 */

public CharArrayWriter(int initialSize) { throw new RuntimeException("Stub!"); }

/**
 * Appends the specified character to this writer.
 *
 * <p> An invocation of this method of the form {@code out.append(c)}
 * behaves in exactly the same way as the invocation
 *
 * <pre>
 *     out.write(c) </pre>
 *
 * @param  c
 *         The 16-bit character to append
 *
 * @return  This writer
 *
 * @since 1.5
 */

public java.io.CharArrayWriter append(char c) { throw new RuntimeException("Stub!"); }

/**
 * Appends the specified character sequence to this writer.
 *
 * <p> An invocation of this method of the form {@code out.append(csq)}
 * behaves in exactly the same way as the invocation
 *
 * <pre>
 *     out.write(csq.toString()) </pre>
 *
 * <p> Depending on the specification of {@code toString} for the
 * character sequence {@code csq}, the entire sequence may not be
 * appended. For instance, invoking the {@code toString} method of a
 * character buffer will return a subsequence whose content depends upon
 * the buffer's position and limit.
 *
 * @param  csq
 *         The character sequence to append.  If {@code csq} is
 *         {@code null}, then the four characters {@code "null"} are
 *         appended to this writer.
 *
 * @return  This writer
 *
 * @since  1.5
 */

public java.io.CharArrayWriter append(java.lang.CharSequence csq) { throw new RuntimeException("Stub!"); }

/**
 * Appends a subsequence of the specified character sequence to this writer.
 *
 * <p> An invocation of this method of the form
 * {@code out.append(csq, start, end)} when
 * {@code csq} is not {@code null}, behaves in
 * exactly the same way as the invocation
 *
 * <pre>
 *     out.write(csq.subSequence(start, end).toString()) </pre>
 *
 * @param  csq
 *         The character sequence from which a subsequence will be
 *         appended.  If {@code csq} is {@code null}, then characters
 *         will be appended as if {@code csq} contained the four
 *         characters {@code "null"}.
 *
 * @param  start
 *         The index of the first character in the subsequence
 *
 * @param  end
 *         The index of the character following the last character in the
 *         subsequence
 *
 * @return  This writer
 *
 * @throws  java.lang.IndexOutOfBoundsException
 *          If {@code start} or {@code end} are negative, {@code start}
 *          is greater than {@code end}, or {@code end} is greater than
 *          {@code csq.length()}
 *
 * @since  1.5
 */

public java.io.CharArrayWriter append(java.lang.CharSequence csq, int start, int end) { throw new RuntimeException("Stub!"); }

/**
 * Close the stream.  This method does not release the buffer, since its
 * contents might still be required. Note: Invoking this method in this class
 * will have no effect.
 */

public void close() { throw new RuntimeException("Stub!"); }

/**
 * Flush the stream.
 */

public void flush() { throw new RuntimeException("Stub!"); }

/**
 * Resets the buffer so that you can use it again without
 * throwing away the already allocated buffer.
 */

public void reset() { throw new RuntimeException("Stub!"); }

/**
 * Returns the current size of the buffer.
 *
 * @return an int representing the current size of the buffer.
 */

public int size() { throw new RuntimeException("Stub!"); }

/**
 * Returns a copy of the input data.
 *
 * @return an array of chars copied from the input data.
 */

public char[] toCharArray() { throw new RuntimeException("Stub!"); }

/**
 * Converts input data to a string.
 * @return the string.
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Writes characters to the buffer.
 * @param c the data to be written
 * @param off       the start offset in the data
 * @param len       the number of chars that are written
 *
 * @throws  java.lang.IndexOutOfBoundsException
 *          If {@code off} is negative, or {@code len} is negative,
 *          or {@code off + len} is negative or greater than the length
 *          of the given array
 */

public void write(char[] c, int off, int len) { throw new RuntimeException("Stub!"); }

/**
 * Writes a character to the buffer.
 */

public void write(int c) { throw new RuntimeException("Stub!"); }

/**
 * Write a portion of a string to the buffer.
 * @param  str  String to be written from
 * @param  off  Offset from which to start reading characters
 * @param  len  Number of characters to be written
 *
 * @throws  java.lang.IndexOutOfBoundsException
 *          If {@code off} is negative, or {@code len} is negative,
 *          or {@code off + len} is negative or greater than the length
 *          of the given string
 */

public void write(java.lang.String str, int off, int len) { throw new RuntimeException("Stub!"); }

/**
 * Writes the contents of the buffer to another character stream.
 *
 * @param out       the output stream to write to
 * @throws java.io.IOException If an I/O error occurs.
 */

public void writeTo(java.io.Writer out) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * The buffer where data is stored.
 */

protected char[] buf;

/**
 * The number of chars in the buffer.
 */

protected int count;
}

