/**
 * Provides the classes and interfaces for cryptographic operations. The
 * cryptographic operations defined in this package include encryption,
 * key generation and key agreement, and Message Authentication Code
 * (MAC) generation.
 *
 * <p>Support for encryption includes symmetric, asymmetric, block, and
 * stream ciphers. This package also supports secure streams and sealed
 * objects.
 *
 * <p>Many of the classes provided in this package are provider-based.  The
 * class itself defines a programming interface to which applications may
 * write.  The implementations themselves may then be written by
 * independent third-party vendors and plugged in seamlessly as needed.
 * Therefore application developers may take advantage of any number of
 * provider-based implementations without having to add or rewrite code.
 *
 * <h2>Package Specification</h2>
 *
 * <ul>
 *   <li><a href="{@docRoot}/../technotes/guides/security/StandardNames.html"><b>
 *     <b>Java<FONT SIZE=-2><SUP>TM</SUP></FONT>
 *     Cryptography Architecture Standard Algorithm Name
 *     Documentation</b></a></li>
 * </ul>
 *
 * <h2>Related Documentation</h2>
 *
 * For further documentation, please see:
 * <ul>
 *   <li>
 *     <a href=
 *       "{@docRoot}/../technotes/guides/security/crypto/CryptoSpec.html">
 *       <b>Java<FONT SIZE=-2><SUP>TM</SUP></FONT>
 *        Cryptography Architecture (JCA) Reference Guide
 *       </b></a></li>
 *   <li>
 *     <a href=
 *       "{@docRoot}/../technotes/guides/security/crypto/HowToImplAProvider.html">
 *       <b>How to Implement a Provider in the
 *       Java<FONT SIZE=-2><SUP>TM</SUP></FONT> Cryptography Architecture
 *       </b></a></li>
 * </ul>
 *
 * @since 1.4
 */

package javax.crypto;
