/*
 * Copyright (c) 2000, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package javax.security.auth.x500;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;

/**
 * <p> This class represents an {@code X500PrivateCredential}.
 * It associates an X.509 certificate, corresponding private key and the
 * KeyStore alias used to reference that exact key pair in the KeyStore.
 * This enables looking up the private credentials for an X.500 principal
 * in a subject.
 *
 * @since 1.4
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class X500PrivateCredential implements javax.security.auth.Destroyable {

/**
 * Creates an X500PrivateCredential that associates an X.509 certificate,
 * a private key and the KeyStore alias.
 *
 * @param cert X509Certificate
 * @param key  PrivateKey for the certificate
 * @exception java.lang.IllegalArgumentException if either {@code cert} or
 * {@code key} is null
 *
 */

public X500PrivateCredential(java.security.cert.X509Certificate cert, java.security.PrivateKey key) { throw new RuntimeException("Stub!"); }

/**
 * Creates an X500PrivateCredential that associates an X.509 certificate,
 * a private key and the KeyStore alias.
 *
 * @param cert X509Certificate
 * @param key  PrivateKey for the certificate
 * @param alias KeyStore alias
 * @exception java.lang.IllegalArgumentException if either {@code cert},
 * {@code key} or {@code alias} is null
 *
 */

public X500PrivateCredential(java.security.cert.X509Certificate cert, java.security.PrivateKey key, java.lang.String alias) { throw new RuntimeException("Stub!"); }

/**
 * Clears the references to the X.509 certificate, private key and the
 * KeyStore alias in this object.
 */

public void destroy() { throw new RuntimeException("Stub!"); }

/**
 * Returns the KeyStore alias.
 *
 * @return the KeyStore alias
 */

public java.lang.String getAlias() { throw new RuntimeException("Stub!"); }

/**
 * Returns the X.509 certificate.
 *
 * @return the X509Certificate
 */

public java.security.cert.X509Certificate getCertificate() { throw new RuntimeException("Stub!"); }

/**
 * Returns the PrivateKey.
 *
 * @return the PrivateKey
 */

public java.security.PrivateKey getPrivateKey() { throw new RuntimeException("Stub!"); }

/**
 * Determines if the references to the X.509 certificate and private key
 * in this object have been cleared.
 *
 * @return true if X509Certificate and the PrivateKey are null
 */

public boolean isDestroyed() { throw new RuntimeException("Stub!"); }
}

