/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// $Id: Source.java 446598 2006-09-15 12:55:40Z jeremias $


package javax.xml.transform;


/**
 * An object that implements this interface contains the information
 * needed to act as source input (XML source or transformation instructions).
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface Source {

/**
 * Get the system identifier that was set with setSystemId.
 *
 * @return The system identifier that was set with setSystemId, or null
 * if setSystemId was not called.
 */

public java.lang.String getSystemId();

/**
 * Set the system identifier for this Source.
 *
 * <p>The system identifier is optional if the source does not
 * get its data from a URL, but it may still be useful to provide one.
 * The application can use a system identifier, for example, to resolve
 * relative URIs and to include in error messages and warnings.</p>
 *
 * @param systemId The system identifier as a URL string.
 */

public void setSystemId(java.lang.String systemId);
}

