/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8wrappers;

import com.android.tools.r8.ArchiveProgramResourceProvider;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.ParseFlagInfo;
import com.android.tools.r8.ParseFlagPrinter;
import com.android.tools.r8.Version;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8wrappers.D8PackageBasedWrapper;
import com.android.tools.r8wrappers.R8Wrapper;
import com.android.tools.r8wrappers.utils.WrapperDiagnosticsHandler;
import com.android.tools.r8wrappers.utils.WrapperFlag;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class D8Wrapper {
    private static final String WRAPPER_STRING = "d8-aosp-wrapper";
    protected static final Origin CLI_ORIGIN = new Origin(Origin.root()){

        @Override
        public String part() {
            return D8Wrapper.WRAPPER_STRING;
        }
    };
    protected static final String NO_DEX_FLAG = "--no-dex-input-jar";
    protected static final String INFO_FLAG = "--info";
    protected static final String PACKAGE_RSP = "--packages";
    protected static final String MODIFIED_PACKAGE_RSP = "--mod-packages";
    protected static final String PACKAGE_OUTPUT = "--package-output";
    protected WrapperDiagnosticsHandler diagnosticsHandler = new WrapperDiagnosticsHandler();
    protected boolean printInfoDiagnostics = false;
    protected List<Path> noDexArchives = new ArrayList<Path>();

    private static List<ParseFlagInfo> getAdditionalFlagsInfo() {
        return Arrays.asList(new WrapperFlag(NO_DEX_FLAG, "Input archive with potential all dex code ignored."), new WrapperFlag(INFO_FLAG, "Print the info-level log messages from the compiler."), new WrapperFlag(PACKAGE_RSP, "List of packages present across all .class files in a jar.\nWhen present, package based dex is used.\nShould be passed as a rsp/text file containing packages separated bywhitespace."), new WrapperFlag(MODIFIED_PACKAGE_RSP, "List of modified present across all .class files in a jar, between this and previous iteration, for incremental dex.\nShould be passed as a rsp/text file containing packages separated by whitespace."));
    }

    private static String getUsageMessage() {
        StringBuilder builder = D8Wrapper.appendLines(new StringBuilder(), "Usage: d8 [options] [@<argfile>] <input-files>", " where <input-files> are any combination of dex, class, zip, jar or apk files", " and each <argfile> is a file containing additional arguments (one per line)", " and options are:");
        new ParseFlagPrinter().addFlags(D8Command.getParseFlagsInformation()).addFlags(D8Wrapper.getAdditionalFlagsInfo()).setIndent(2).appendLinesToBuilder(builder);
        return builder.toString();
    }

    private static StringBuilder appendLines(StringBuilder builder, String ... lines) {
        for (String line : lines) {
            builder.append(line).append(System.lineSeparator());
        }
        return builder;
    }

    private static boolean isPackageBasedCompilation(String[] args) {
        for (int i15 = 0; i15 < args.length; ++i15) {
            if (!args[i15].equals(PACKAGE_RSP)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws CompilationFailedException, IOException, ExecutionException, InterruptedException {
        String[] remainingArgs;
        boolean packageBasedCompilation = D8Wrapper.isPackageBasedCompilation(args);
        D8Wrapper wrapper = packageBasedCompilation ? new D8PackageBasedWrapper() : new D8Wrapper();
        if (D8Wrapper.printHelpOrVersion(wrapper, remainingArgs = wrapper.parseWrapperArguments(args))) {
            return;
        }
        wrapper.run(remainingArgs);
    }

    public void run(String[] remainingArgs) throws CompilationFailedException, IOException, ExecutionException, InterruptedException {
        D8Command.Builder builder = D8Command.parse(remainingArgs, CLI_ORIGIN, this.diagnosticsHandler);
        this.applyWrapperArguments(builder);
        R8Wrapper.applyCommonCompilerArguments(builder);
        D8.run((D8Command)builder.build());
    }

    private static boolean printHelpOrVersion(D8Wrapper wrapper, String[] remainingArgs) {
        D8Command.Builder builder = D8Command.parse(remainingArgs, CLI_ORIGIN, wrapper.diagnosticsHandler);
        if (builder.isPrintHelp()) {
            System.out.println(D8Wrapper.getUsageMessage());
            return true;
        }
        if (builder.isPrintVersion()) {
            System.out.println("D8(d8-aosp-wrapper) " + Version.getVersionString());
            return true;
        }
        return false;
    }

    public String[] parseWrapperArguments(String[] args) {
        ArrayList<String> remainingArgs = new ArrayList<String>();
        block8: for (int i15 = 0; i15 < args.length; ++i15) {
            String arg;
            switch (arg = args[i15]) {
                case "--info": {
                    this.printInfoDiagnostics = true;
                    continue block8;
                }
                case "--no-dex-input-jar": {
                    if (++i15 >= args.length) {
                        throw new RuntimeException("Missing argument to --no-dex-input-jar");
                    }
                    Path path = Paths.get(args[i15], new String[0]);
                    if (!Files.isRegularFile(path, new LinkOption[0])) {
                        throw new RuntimeException("Unexpected argument to --no-dex-input-jar. Expected an archive");
                    }
                    this.noDexArchives.add(path);
                    continue block8;
                }
                default: {
                    remainingArgs.add(arg);
                }
            }
        }
        return remainingArgs.toArray(new String[0]);
    }

    private void applyWrapperArguments(D8Command.Builder builder) throws IOException {
        this.diagnosticsHandler.setWarnOnUnsupportedMainDexList(true);
        this.diagnosticsHandler.setPrintInfoDiagnostics(this.printInfoDiagnostics);
        for (Path path : this.noDexArchives) {
            builder.addProgramResourceProvider(ArchiveProgramResourceProvider.fromArchive(path, ArchiveProgramResourceProvider::includeClassFileEntries));
        }
    }
}

