/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8wrappers.retrace;

import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.retrace.ProguardMapProducer;
import com.android.tools.r8.retrace.RetraceStackTraceContext;
import com.android.tools.r8.retrace.RetracedClassReference;
import com.android.tools.r8.retrace.RetracedMethodReference;
import com.android.tools.r8.retrace.Retracer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RetraceWrapper {
    private static final List<String> AOSP_MAP_SEARCH_PATHS = Arrays.asList("out/target/common/obj/APPS", "out/target/common/obj/JAVA_LIBRARIES", "out/soong/.intermediates");
    private static final String USAGE = String.join((CharSequence)System.lineSeparator(), "Usage: retrace [<option>]* [<file>]", "where <file> is the file to retrace (default stdin)", "and for retracing build server artifacts <option>s are:", "  --bid <build id>            # Build identifier, e.g., 1234 or P1234", "  --target <target>           # Build target name, e.g., coral-userdebug", "  --branch <branch>           # Branch, e.g., master (only needed when bid is not a", "                              # build number)", "or for controlling map lookup/location <option>s are:", "  --default-map <file/app>    # Default map to retrace lines that don't auto-identify.", "                              # The argument can be a local file or it can be any", "                              # unique substring of a map path found in the map-table.", "  --map-search-path <path>    # Path to search for mappings that support auto-identify.", "                              # Separate <path> entries by colon ':'.", "                              # Default '" + String.join((CharSequence)":", AOSP_MAP_SEARCH_PATHS) + "'.", "other supported <option>s are:", "  --print-map-table           # Print the table of identified mapping files and exit.", "  --cwd-relative-search-paths # When this flag is set, the search paths given in", "                              # the --map-search-path flag are assumed to be relative", "                              # to the current directory. Otherwise, these paths are", "                              # assumed to be relative to the root of the Android", "                              # checkout.", "  --temp <path>               # Use <path> as the temporary directory without cleanup.", "                              # This will cause build artifacts to be cached in temp.", "  -h, --help                  # Print this message.");
    private static final String ESCAPING_EXCEPTION_MARKER = "Exception in thread \"";
    private static final String CAUSED_BY_EXCEPTION_MARKER = "Caused by: ";
    private static final String SUPPRESSED_EXCEPTION_MARKER = "Suppressed: ";
    private static final String AOSP_SF_MARKER = "go/retraceme ";
    private static final String R8_SF_MARKER = "R8_";
    private static final String MAP_ID_HEADER_MARKER = "# pg_map_id: ";
    private static final String MAP_HASH_HEADER_MARKER = "# pg_map_hash: SHA-256 ";
    private static final Map<String, LazyRetracer> RETRACERS = new HashMap<String, LazyRetracer>();
    private static final List<String> PENDING_MESSAGES = new ArrayList<String>();

    private static void flushPendingMessages() {
        PENDING_MESSAGES.forEach(System.err::println);
    }

    private static void info(String message) {
        PENDING_MESSAGES.add("Info: " + message);
    }

    private static void warning(String message) {
        PENDING_MESSAGES.add("Warning: " + message);
    }

    private static RuntimeException error(String message) {
        RetraceWrapper.flushPendingMessages();
        throw new RuntimeException(message);
    }

    private static MapInfo readMapHeaderInfo(Path path) throws IOException {
        String mapId = null;
        String mapHash = null;
        try (BufferedReader reader = Files.newBufferedReader(path);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("#")) {
                    break;
                }
                if (mapId == null) {
                    mapId = RetraceWrapper.tryParseMapIdHeader(line);
                }
                if (mapHash != null) continue;
                mapHash = RetraceWrapper.tryParseMapHashHeader(line);
            }
        }
        if (mapId != null && mapHash != null) {
            return new MapInfo(mapId, mapHash);
        }
        return null;
    }

    private static Path getProjectRoot() throws URISyntaxException {
        Path retraceJarPath;
        Path hostPath = Paths.get("out", "host");
        Path hostSoongPath = Paths.get("out", "soong");
        for (Path current = retraceJarPath = Paths.get(RetraceWrapper.class.getProtectionDomain().getCodeSource().getLocation().toURI()); current != null; current = current.getParent()) {
            if (!current.endsWith(hostPath) && !current.endsWith(hostSoongPath)) continue;
            return current.getParent().getParent();
        }
        RetraceWrapper.info("Unable to determine the project root based on the retrace.jar location: " + retraceJarPath);
        return null;
    }

    private static LazyRetracer getRetracerForAosp(String sourceFile) {
        MapInfo stackLineInfo = RetraceWrapper.tryParseSourceFileMarkerForAosp(sourceFile);
        return stackLineInfo == null ? null : RETRACERS.get(stackLineInfo.id);
    }

    private static LazyRetracer getRetracerForR8(String sourceFile) {
        MapInfo stackLineInfo = RetraceWrapper.tryParseSourceFileMarkerForR8(sourceFile);
        if (stackLineInfo == null) {
            return null;
        }
        LazyRetracer retracer = RETRACERS.get(stackLineInfo.id);
        if (retracer == null) {
            RetraceWrapper.info("Could not identify a mapping file for lines with R8 tag: " + stackLineInfo);
        }
        return retracer;
    }

    private static String tryParseMapIdHeader(String line) {
        return RetraceWrapper.tryParseMapHeaderLine(line, MAP_ID_HEADER_MARKER);
    }

    private static String tryParseMapHashHeader(String line) {
        return RetraceWrapper.tryParseMapHeaderLine(line, MAP_HASH_HEADER_MARKER);
    }

    private static String tryParseMapHeaderLine(String line, String headerMarker) {
        if (line.startsWith(headerMarker)) {
            return line.substring(headerMarker.length());
        }
        return null;
    }

    private static FrameLine tryParseFrameLine(String line) {
        OptionalInt lineNumber;
        String sourceFile;
        String atMarker = "at ";
        int atIndex = line.indexOf(atMarker);
        if (atIndex < 0) {
            return null;
        }
        int parenStartIndex = line.indexOf(40, atIndex);
        if (parenStartIndex < 0) {
            return null;
        }
        int parenEndIndex = line.indexOf(41, parenStartIndex);
        if (parenEndIndex < 0) {
            return null;
        }
        int classAndMethodSeperatorIndex = line.lastIndexOf(46, parenStartIndex);
        if (classAndMethodSeperatorIndex < 0) {
            return null;
        }
        int classStartIndex = atIndex + atMarker.length();
        String clazz = line.substring(classStartIndex, classAndMethodSeperatorIndex);
        String method = line.substring(classAndMethodSeperatorIndex + 1, parenStartIndex);
        int sourceAndLineSeperatorIndex = line.lastIndexOf(58, parenEndIndex);
        if (parenStartIndex < sourceAndLineSeperatorIndex) {
            sourceFile = line.substring(parenStartIndex + 1, sourceAndLineSeperatorIndex);
            try {
                lineNumber = OptionalInt.of(Integer.parseInt(line.substring(sourceAndLineSeperatorIndex + 1, parenEndIndex)));
            }
            catch (NumberFormatException e15) {
                lineNumber = OptionalInt.empty();
            }
        } else {
            sourceFile = line.substring(parenStartIndex + 1, parenEndIndex);
            lineNumber = OptionalInt.empty();
        }
        return new FrameLine(line, classStartIndex, parenEndIndex + 1, Reference.classFromTypeName(clazz), method, sourceFile, lineNumber);
    }

    private static int indexOfExceptionStart(String line) {
        int start;
        int i15 = line.indexOf(ESCAPING_EXCEPTION_MARKER);
        if (i15 >= 0 && (start = line.indexOf("\" ", i15 + ESCAPING_EXCEPTION_MARKER.length())) > 0) {
            return start;
        }
        i15 = line.indexOf(CAUSED_BY_EXCEPTION_MARKER);
        if (i15 >= 0) {
            return i15 + CAUSED_BY_EXCEPTION_MARKER.length();
        }
        i15 = line.indexOf(SUPPRESSED_EXCEPTION_MARKER);
        if (i15 >= 0) {
            return i15 + SUPPRESSED_EXCEPTION_MARKER.length();
        }
        return -1;
    }

    private static ExceptionLine tryParseExceptionLine(String line) {
        int start = RetraceWrapper.indexOfExceptionStart(line);
        if (start < 0) {
            return null;
        }
        int end = line.indexOf(58, start);
        if (end < 0) {
            return null;
        }
        String exception = line.substring(start, end);
        return new ExceptionLine(line, start, end, Reference.classFromTypeName(exception));
    }

    private static MapInfo tryParseSourceFileMarkerForAosp(String sourceFile) {
        if (!sourceFile.startsWith(AOSP_SF_MARKER)) {
            return null;
        }
        int hashStart = AOSP_SF_MARKER.length();
        String mapHash = sourceFile.substring(hashStart);
        return new MapInfo(mapHash, mapHash);
    }

    private static MapInfo tryParseSourceFileMarkerForR8(String sourceFile) {
        if (!sourceFile.startsWith(R8_SF_MARKER)) {
            return null;
        }
        int versionStart = R8_SF_MARKER.length();
        int mapHashStart = sourceFile.indexOf(95, versionStart) + 1;
        if (mapHashStart <= 0) {
            return null;
        }
        String version = sourceFile.substring(versionStart, mapHashStart - 1);
        String mapHash = sourceFile.substring(mapHashStart);
        return new MapInfo(version, mapHash);
    }

    private static void printIdentityStackTrace(ExceptionLine exceptionLine, List<FrameLine> frames) {
        if (exceptionLine != null) {
            System.out.println(exceptionLine.line);
        }
        frames.forEach(frame -> System.out.println(frame.line));
    }

    private static void retrace(InputStream stream, LazyRetracer defaultRetracer, Path tempDir) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String currentLine = reader.readLine();
        ArrayList<FrameLine> frames = new ArrayList<FrameLine>();
        while (currentLine != null) {
            ExceptionLine exceptionLine = RetraceWrapper.tryParseExceptionLine(currentLine);
            if (exceptionLine != null && (currentLine = reader.readLine()) == null) {
                RetraceWrapper.printIdentityStackTrace(exceptionLine, Collections.emptyList());
                return;
            }
            FrameLine topFrameLine = RetraceWrapper.tryParseFrameLine(currentLine);
            if (topFrameLine == null) {
                RetraceWrapper.printIdentityStackTrace(exceptionLine, Collections.emptyList());
                System.out.println(currentLine);
                currentLine = reader.readLine();
                continue;
            }
            FrameLine frame = topFrameLine;
            while (frame != null && frame.sourceFile.equals(topFrameLine.sourceFile)) {
                frames.add(frame);
                currentLine = reader.readLine();
                frame = currentLine == null ? null : RetraceWrapper.tryParseFrameLine(currentLine);
            }
            RetraceWrapper.retraceStackTrace(defaultRetracer, exceptionLine, frames, tempDir);
            frames.clear();
        }
    }

    private static LazyRetracer determineRetracer(String sourceFile, LazyRetracer defaultRetracer) {
        LazyRetracer lazyRetracer = RetraceWrapper.getRetracerForR8(sourceFile);
        if (lazyRetracer != null) {
            return lazyRetracer;
        }
        lazyRetracer = RetraceWrapper.getRetracerForAosp(sourceFile);
        if (lazyRetracer != null) {
            return lazyRetracer;
        }
        return defaultRetracer;
    }

    private static void retraceStackTrace(LazyRetracer defaultRetracer, ExceptionLine exceptionLine, List<FrameLine> frames, Path tempDir) throws Exception {
        String sourceFile = frames.get((int)0).sourceFile;
        LazyRetracer lazyRetracer = RetraceWrapper.determineRetracer(sourceFile, defaultRetracer);
        if (lazyRetracer == null) {
            RetraceWrapper.printIdentityStackTrace(exceptionLine, frames);
            return;
        }
        Retracer retracer = lazyRetracer.getRetracer(tempDir);
        ArrayList finalResultNodes = new ArrayList();
        RetraceWrapper.retraceOptionalExceptionLine(retracer, exceptionLine, (context, parentResult) -> RetraceWrapper.retraceFrameRecursive(retracer, context, parentResult, 0, frames).forEach(finalResultNodes::add));
        if (finalResultNodes.isEmpty()) {
            RetraceWrapper.printIdentityStackTrace(exceptionLine, frames);
            return;
        }
        if (finalResultNodes.size() > 1) {
            System.out.println("Printing " + finalResultNodes.size() + " ambiguous stacks separated by <OR>.\nIf this is unexpected, please file a bug on R8 and attach the content of the raw stack trace and the mapping file: " + lazyRetracer.getMapLocation() + "\nPublic tracker at https://issuetracker.google.com/issues/new?component=326788");
        }
        for (int i15 = 0; i15 < finalResultNodes.size(); ++i15) {
            if (i15 > 0) {
                System.out.println("<OR>");
            }
            ResultNode node = (ResultNode)finalResultNodes.get(i15);
            node.print();
        }
    }

    private static void retraceOptionalExceptionLine(Retracer retracer, ExceptionLine exceptionLine, BiConsumer<RetraceStackTraceContext, ResultNode> resultCallback) {
        ResultNode initialResultNode = null;
        if (exceptionLine == null) {
            resultCallback.accept(RetraceStackTraceContext.empty(), initialResultNode);
            return;
        }
        retracer.retraceThrownException(exceptionLine.exception).forEach(element -> resultCallback.accept(element.getContext(), new ResultNode(initialResultNode, exceptionLine.plug(element.getRetracedClass().getTypeName()))));
    }

    private static Stream<ResultNode> retraceFrameRecursive(Retracer retracer, RetraceStackTraceContext context, ResultNode parentResult, int frameIndex, List<FrameLine> frames) {
        if (frameIndex >= frames.size()) {
            return Stream.of(parentResult);
        }
        FrameLine frameLine = frames.get(frameIndex);
        return retracer.retraceFrame(context, frameLine.lineNumber, frameLine.clazz, frameLine.methodName).flatMap(frameElement -> {
            class ResultLinker {
                ResultNode current;

                public ResultLinker(ResultNode current) {
                    this.current = current;
                }

                public void link(String nextResult) {
                    this.current = new ResultNode(this.current, nextResult);
                }
            }
            ResultLinker linker = new ResultLinker(parentResult);
            frameElement.forEachRewritten(frame -> {
                RetracedMethodReference method = frame.getMethodReference();
                RetracedClassReference holder = method.getHolderClass();
                int origPos = method.getOriginalPositionOrDefault(-1);
                linker.link(frameLine.plug(holder.getTypeName() + "." + method.getMethodName() + "(" + frame.getSourceFile().getOrInferSourceFile() + (origPos >= 0 ? ":" + origPos : "") + ")"));
            });
            return RetraceWrapper.retraceFrameRecursive(retracer, frameElement.getRetraceStackTraceContext(), linker.current, frameIndex + 1, frames);
        });
    }

    private static void populateLocalMappingFileMap(List<String> searchPaths, boolean cwdRelativeSearchPaths) throws Exception {
        Path projectRoot = RetraceWrapper.getProjectRoot();
        if (projectRoot == null) {
            return;
        }
        Path prebuiltR8MapPath = projectRoot.resolve("prebuilts").resolve("r8").resolve("r8.jar.map");
        MapInfo prebuiltR8MapInfo = RetraceWrapper.readMapHeaderInfo(prebuiltR8MapPath);
        if (prebuiltR8MapInfo == null) {
            RetraceWrapper.info("Unable to read expected prebuilt R8 map in " + prebuiltR8MapPath);
        } else {
            RETRACERS.put(prebuiltR8MapInfo.id, new LocalLazyRetracer(prebuiltR8MapInfo, prebuiltR8MapPath));
        }
        for (String path : searchPaths) {
            Path resolvedPath = cwdRelativeSearchPaths ? Paths.get(path, new String[0]) : projectRoot.resolve(Paths.get(path, new String[0]));
            if (Files.notExists(resolvedPath, new LinkOption[0])) {
                RetraceWrapper.error("Invalid search path entry: " + resolvedPath);
            }
            Files.walkFileTree(resolvedPath, (FileVisitor<? super Path>)new FileVisitor<Path>(){
                final Path mapFileName = Paths.get("proguard_dictionary", new String[0]);

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    MapInfo mapInfo;
                    if (file.endsWith(this.mapFileName) && (mapInfo = RetraceWrapper.readMapHeaderInfo(file)) != null) {
                        RETRACERS.put(mapInfo.id, new LocalLazyRetracer(mapInfo, file));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private static List<Path> collectMetaMappingFiles(BuildInfo buildInfo, Path directory) throws IOException {
        if (!Files.exists(directory, new LinkOption[0])) {
            return Collections.emptyList();
        }
        String suffix = buildInfo.getMetaMappingFileSuffix();
        try (Stream<Path> stream = Files.walk(directory, new FileVisitOption[0]);){
            List<Path> list = stream.filter(p15 -> p15.toString().endsWith(suffix)).collect(Collectors.toList());
            return list;
        }
    }

    private static void populateRemoteMappingFileMap(BuildInfo buildInfo, Path tempDir) throws IOException, InterruptedException {
        Path baseDirectory = RetraceWrapper.getTempBuildDirPath(buildInfo, tempDir);
        List<Path> metaMappings = RetraceWrapper.collectMetaMappingFiles(buildInfo, baseDirectory);
        if (metaMappings.isEmpty()) {
            RetraceWrapper.ensureFetchArtifactCommand();
            RetraceWrapper.ensureTempBuildDir(buildInfo, tempDir);
            System.out.println("Fetching meta information for mapping files from build server...");
            RetraceWrapper.fetchArtifactGlob(buildInfo, "**/*" + buildInfo.getMetaMappingFileSuffix(), baseDirectory);
            metaMappings = RetraceWrapper.collectMetaMappingFiles(buildInfo, baseDirectory);
            System.out.println("Meta information files found: " + metaMappings.size());
            System.out.println();
        }
        for (Path metaMapping : metaMappings) {
            List<String> lines = Files.readAllLines(metaMapping);
            for (int i15 = 0; i15 < lines.size(); ++i15) {
                String subline;
                String line = lines.get(i15).trim();
                if (!line.startsWith("mappings:") || !line.endsWith("{")) continue;
                String id5 = null;
                String location = null;
                String type = null;
                int j15 = i15 + 1;
                while (j15 < lines.size() && !(subline = lines.get(j15++).trim()).startsWith("}")) {
                    if (subline.startsWith("identifier:")) {
                        id5 = RetraceWrapper.getQuotedString(subline);
                        continue;
                    }
                    if (subline.startsWith("location:")) {
                        location = RetraceWrapper.getQuotedString(subline);
                        continue;
                    }
                    if (subline.startsWith("type:")) {
                        type = subline.substring(5).trim();
                        continue;
                    }
                    throw RetraceWrapper.error("no match");
                }
                if (id5 != null && location != null && type != null && type.equals("R8") && id5.length() == 64) {
                    MapInfo mapInfo = new MapInfo(id5, id5);
                    String mappingFile = RetraceWrapper.deriveMappingFileFromMetaMapping(buildInfo, baseDirectory, metaMapping);
                    RETRACERS.put(id5, new RemoteLazyRetracer(mapInfo, buildInfo, mappingFile, location));
                    continue;
                }
                ArrayList<String> message = new ArrayList<String>();
                message.add("Invalid mapping entry starting at line " + i15 + ":");
                for (int k15 = i15; k15 < j15; ++k15) {
                    message.add(lines.get(k15));
                }
                throw RetraceWrapper.error(String.join((CharSequence)System.lineSeparator(), message));
            }
        }
    }

    private static String getQuotedString(String line) {
        return line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
    }

    private static String deriveMappingFileFromMetaMapping(BuildInfo buildInfo, Path base, Path metaMapping) {
        String relative = base.relativize(metaMapping).toString();
        return relative.replace(buildInfo.getMetaMappingFileSuffix(), buildInfo.getMappingFileSuffix());
    }

    private static String readAllLines(InputStream stream) {
        return new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.joining(System.lineSeparator()));
    }

    private static void ensureFetchArtifactCommand() {
        try {
            Process process = new ProcessBuilder("fetch_artifact", "--help").start();
            process.destroy();
        }
        catch (IOException e15) {
            throw RetraceWrapper.error(String.join((CharSequence)System.lineSeparator(), "Using build identification flags requires 'fetch_artifact'.", "Cannot find 'fetch_artifact' in PATH. Install it using:", "  sudo apt install android-fetch-artifact"));
        }
    }

    private static List<String> fetchArtifactCommand(BuildInfo buildInfo, String artifact, String entry) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("fetch_artifact");
        command.addAll(Arrays.asList("--bid", buildInfo.id));
        command.addAll(Arrays.asList("--target", buildInfo.target));
        if (buildInfo.branch != null) {
            command.addAll(Arrays.asList("--branch", buildInfo.branch));
        }
        if (entry != null) {
            command.addAll(Arrays.asList("--zip_entry", entry));
        }
        command.add(artifact);
        return command;
    }

    private static Path fetchArtifact(BuildInfo buildInfo, String artifact, String entry, Path tempDir) throws IOException, InterruptedException {
        Path tempDirForBuild = RetraceWrapper.ensureTempBuildDir(buildInfo, tempDir);
        Path outFile = tempDirForBuild.resolve(entry != null ? entry : artifact);
        if (Files.exists(outFile, new LinkOption[0])) {
            return outFile;
        }
        List<String> command = RetraceWrapper.fetchArtifactCommand(buildInfo, artifact, entry);
        Process process = new ProcessBuilder(command).directory(tempDirForBuild.toFile()).redirectError(ProcessBuilder.Redirect.INHERIT).start();
        process.waitFor();
        if (process.exitValue() == 0) {
            return outFile;
        }
        throw RetraceWrapper.error(String.join((CharSequence)System.lineSeparator(), "Failed attempt to fetch_artifact.", "Command: " + String.join((CharSequence)" ", command), "Stdout:", RetraceWrapper.readAllLines(process.getInputStream())));
    }

    private static void fetchArtifactGlob(BuildInfo buildInfo, String artifact, Path tempDirForBuild) throws IOException, InterruptedException {
        List<String> command = RetraceWrapper.fetchArtifactCommand(buildInfo, artifact, null);
        command.add("--preserve_directory_structure");
        System.out.println(String.join((CharSequence)" ", command));
        Process process = new ProcessBuilder(command).directory(tempDirForBuild.toFile()).redirectError(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT).start();
        process.waitFor();
        if (process.exitValue() != 0) {
            throw RetraceWrapper.error(String.join((CharSequence)System.lineSeparator(), "Failed attempt to fetch_artifact.", "Command: " + String.join((CharSequence)" ", command)));
        }
    }

    private static Path getTempBuildDirPath(BuildInfo buildInfo, Path tempDir) {
        return tempDir.resolve(buildInfo.id + "_" + buildInfo.target);
    }

    private static Path ensureTempBuildDir(BuildInfo buildInfo, Path tempDir) throws IOException {
        Path tempDirForBuild = RetraceWrapper.getTempBuildDirPath(buildInfo, tempDir);
        if (Files.notExists(tempDirForBuild, new LinkOption[0])) {
            Files.createDirectories(tempDirForBuild, new FileAttribute[0]);
        }
        return tempDirForBuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String bid = null;
        String target = null;
        String branch = null;
        String stackTraceFile = null;
        String defaultMapArg = null;
        boolean printMappingFileTable = false;
        boolean cwdRelativeSearchPaths = false;
        Path userTempDir = null;
        List<String> searchPaths = AOSP_MAP_SEARCH_PATHS;
        for (int i15 = 0; i15 < args.length; ++i15) {
            String arg = args[i15];
            if (arg.equals("-h") || arg.equals("--help")) {
                System.out.println(USAGE);
                return;
            }
            if (arg.equals("--bid")) {
                if (++i15 == args.length) {
                    throw RetraceWrapper.error("No argument given for --bid");
                }
                bid = args[i15];
                continue;
            }
            if (arg.equals("--target")) {
                if (++i15 == args.length) {
                    throw RetraceWrapper.error("No argument given for --target");
                }
                target = args[i15];
                continue;
            }
            if (arg.equals("--branch")) {
                if (++i15 == args.length) {
                    throw RetraceWrapper.error("No argument given for --branch");
                }
                branch = args[i15];
                continue;
            }
            if (arg.equals("--default-map")) {
                if (++i15 == args.length) {
                    throw RetraceWrapper.error("No argument given for --default-map");
                }
                defaultMapArg = args[i15];
                continue;
            }
            if (arg.equals("--map-search-path")) {
                if (++i15 == args.length) {
                    throw RetraceWrapper.error("No argument given for --map-search-path");
                }
                searchPaths = RetraceWrapper.parseSearchPath(args[i15]);
                continue;
            }
            if (arg.equals("--print-map-table")) {
                printMappingFileTable = true;
                continue;
            }
            if (arg.equals("--cwd-relative-search-paths")) {
                cwdRelativeSearchPaths = true;
                continue;
            }
            if (arg.equals("--temp")) {
                if (++i15 == args.length) {
                    throw RetraceWrapper.error("No argument given for --temp");
                }
                userTempDir = Paths.get(args[i15], new String[0]);
                continue;
            }
            if (arg.startsWith("-")) {
                throw RetraceWrapper.error("Unknown option: " + arg);
            }
            if (stackTraceFile != null) {
                throw RetraceWrapper.error("At most one input file is supported.");
            }
            stackTraceFile = arg;
        }
        BuildInfo buildInfo = null;
        if (bid != null || target != null) {
            if (bid == null || target == null) {
                throw RetraceWrapper.error("Must supply a target together with a build id.");
            }
            buildInfo = new BuildInfo(bid, target, branch);
        }
        Path tempDir = userTempDir != null ? userTempDir : Files.createTempDirectory("retrace", new FileAttribute[0]);
        try {
            if (buildInfo != null) {
                RetraceWrapper.populateRemoteMappingFileMap(buildInfo, tempDir);
            } else {
                RetraceWrapper.populateLocalMappingFileMap(searchPaths, cwdRelativeSearchPaths);
            }
            if (printMappingFileTable) {
                ArrayList<String> keys = new ArrayList<String>(RETRACERS.keySet());
                keys.sort(String::compareTo);
                for (String key : keys) {
                    LazyRetracer retracer = RETRACERS.get(key);
                    System.out.println(key + " -> " + retracer.getMapLocation());
                }
                return;
            }
            LazyRetracer defaultRetracer = RetraceWrapper.findDefaultRetracer(defaultMapArg);
            if (defaultRetracer != null) {
                System.out.println("Using default mapping: " + defaultRetracer.getMapLocation());
            }
            if (stackTraceFile == null) {
                RetraceWrapper.retrace(System.in, defaultRetracer, tempDir);
            } else {
                Path path = Paths.get(stackTraceFile, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    throw RetraceWrapper.error("Input file does not exist: " + stackTraceFile);
                }
                try (InputStream stream = Files.newInputStream(path, StandardOpenOption.READ);){
                    RetraceWrapper.retrace(stream, defaultRetracer, tempDir);
                }
            }
            RetraceWrapper.flushPendingMessages();
        }
        finally {
            if (userTempDir != tempDir) {
                RetraceWrapper.deleteDirectory(tempDir);
            }
        }
    }

    private static LazyRetracer findDefaultRetracer(String key) {
        if (key == null) {
            return null;
        }
        if (Files.isRegularFile(Paths.get(key, new String[0]), new LinkOption[0])) {
            return new LocalLazyRetracer(null, Paths.get(key, new String[0]));
        }
        ArrayList<LazyRetracer> matches = new ArrayList<LazyRetracer>();
        for (LazyRetracer retracer : RETRACERS.values()) {
            if (!retracer.getMapLocation().contains(key)) continue;
            matches.add(retracer);
        }
        if (matches.size() == 1) {
            return (LazyRetracer)matches.get(0);
        }
        StringBuilder builder = new StringBuilder("--default-map ").append(key);
        if (matches.isEmpty()) {
            builder.append(" did not match a local file or any map location in mapping table.").append(" (Use --print-map-table to view the table).");
        } else {
            builder.append(" matched ").append(matches.size()).append(" map paths:\n");
            for (LazyRetracer match : matches) {
                builder.append(match.getMapLocation()).append('\n');
            }
        }
        throw RetraceWrapper.error(builder.toString());
    }

    private static void deleteDirectory(Path directory) throws IOException {
        Files.walk(directory, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEachOrdered(p15 -> {
            try {
                Files.delete(p15);
            }
            catch (IOException e15) {
                throw new RuntimeException(e15);
            }
        });
    }

    private static List<String> parseSearchPath(String paths) {
        int end;
        int length = paths.length();
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        do {
            int split;
            String path;
            if ((path = paths.substring(start, end = (split = paths.indexOf(58, start)) != -1 ? split : length).trim()).isEmpty()) continue;
            result.add(path);
        } while ((start = end + 1) < length);
        return result;
    }

    private static class MapInfo {
        final String id;
        final String hash;

        public MapInfo(String id5, String hash) {
            assert (id5 != null);
            assert (hash != null);
            this.id = id5;
            this.hash = hash;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            MapInfo otherMapInfo = (MapInfo)other;
            return Objects.equals(this.id, otherMapInfo.id) && Objects.equals(this.hash, otherMapInfo.hash);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.hash);
        }

        public String toString() {
            return "MapInfo{id='" + this.id + '\'' + ", hash='" + this.hash + '\'' + '}';
        }
    }

    private static interface LazyRetracer {
        public String getMapLocation();

        public Retracer getRetracer(Path var1) throws Exception;
    }

    private static class FrameLine
    extends LineWithHole {
        final ClassReference clazz;
        final String methodName;
        final String sourceFile;
        final OptionalInt lineNumber;

        public FrameLine(String line, int start, int end, ClassReference clazz, String methodName, String sourceFile, OptionalInt lineNumber) {
            super(line, start, end);
            this.clazz = clazz;
            this.methodName = methodName;
            this.sourceFile = sourceFile;
            this.lineNumber = lineNumber;
        }
    }

    private static class ExceptionLine
    extends LineWithHole {
        final ClassReference exception;

        public ExceptionLine(String line, int start, int end, ClassReference exception) {
            super(line, start, end);
            this.exception = exception;
        }
    }

    private static class ResultNode {
        final ResultNode parent;
        final String line;

        public ResultNode(ResultNode parent, String line) {
            this.parent = parent;
            this.line = line;
        }

        public void print() {
            if (this.parent != null) {
                this.parent.print();
            }
            System.out.println(this.line);
        }
    }

    private static class LocalLazyRetracer
    implements LazyRetracer {
        final MapInfo mapInfo;
        final Path mapPath;
        private Retracer lazyRetracer = null;

        public LocalLazyRetracer(MapInfo mapInfo, Path mapPath) {
            this.mapInfo = mapInfo;
            this.mapPath = mapPath;
        }

        @Override
        public String getMapLocation() {
            return this.mapPath.toString();
        }

        @Override
        public Retracer getRetracer(Path tempDir) throws Exception {
            if (this.lazyRetracer == null) {
                this.lazyRetracer = Retracer.createDefault(ProguardMapProducer.fromPath(this.mapPath), new ForwardingDiagnosticsHander());
            }
            return this.lazyRetracer;
        }
    }

    private static class BuildInfo {
        final String id;
        final String target;
        final String branch;

        public BuildInfo(String id5, String target, String branch) {
            this.id = id5;
            this.target = target;
            this.branch = branch;
        }

        public String getMetaMappingFileSuffix() {
            return "-proguard-dict-mapping-" + this.id + ".textproto";
        }

        public String getMappingFileSuffix() {
            return "-proguard-dict-" + this.id + ".zip";
        }

        public String toString() {
            return "bid=" + this.id + ", target=" + this.target + (this.branch == null ? "" : ", branch=" + this.branch);
        }
    }

    private static class RemoteLazyRetracer
    implements LazyRetracer {
        private final MapInfo mapInfo;
        private final BuildInfo buildInfo;
        private final String mappingFile;
        private final String zipEntry;
        private Retracer lazyRetracer = null;

        public RemoteLazyRetracer(MapInfo mapInfo, BuildInfo buildInfo, String mappingFile, String zipEntry) {
            this.mapInfo = mapInfo;
            this.buildInfo = buildInfo;
            this.mappingFile = mappingFile;
            this.zipEntry = zipEntry;
        }

        @Override
        public String getMapLocation() {
            return String.join((CharSequence)" ", RetraceWrapper.fetchArtifactCommand(this.buildInfo, this.mappingFile, this.zipEntry));
        }

        @Override
        public Retracer getRetracer(Path tempDir) throws IOException, InterruptedException {
            if (this.lazyRetracer == null) {
                Path mapFile = RetraceWrapper.fetchArtifact(this.buildInfo, this.mappingFile, this.zipEntry, tempDir);
                this.lazyRetracer = Retracer.createDefault(ProguardMapProducer.fromPath(mapFile), new ForwardingDiagnosticsHander());
            }
            return this.lazyRetracer;
        }
    }

    private static class LineWithHole {
        final String line;
        final int start;
        final int end;

        public LineWithHole(String line, int start, int end) {
            this.line = line;
            this.start = start;
            this.end = end;
        }

        public String plug(String string) {
            return this.line.substring(0, this.start) + string + this.line.substring(this.end);
        }
    }

    private static class ForwardingDiagnosticsHander
    implements DiagnosticsHandler {
        private ForwardingDiagnosticsHander() {
        }

        @Override
        public void error(Diagnostic error) {
            throw RetraceWrapper.error(error.getDiagnosticMessage());
        }

        @Override
        public void warning(Diagnostic warning) {
            RetraceWrapper.warning(warning.getDiagnosticMessage());
        }

        @Override
        public void info(Diagnostic info) {
            RetraceWrapper.info(info.getDiagnosticMessage());
        }
    }
}

