/*
 * Decompiled with CFR 0.152.
 */
package androidx.renderscript;

import android.os.Build;
import androidx.renderscript.Allocation;
import androidx.renderscript.Element;
import androidx.renderscript.Matrix4f;
import androidx.renderscript.RSIllegalArgumentException;
import androidx.renderscript.RenderScript;
import androidx.renderscript.Script;
import androidx.renderscript.ScriptIntrinsic;

public class ScriptIntrinsicLUT
extends ScriptIntrinsic {
    private final Matrix4f mMatrix = new Matrix4f();
    private Allocation mTables;
    private final byte[] mCache = new byte[1024];
    private boolean mDirty = true;
    private static final int INTRINSIC_API_LEVEL = 19;

    protected ScriptIntrinsicLUT(long id, RenderScript rs) {
        super(id, rs);
    }

    public static ScriptIntrinsicLUT create(RenderScript rs, Element e) {
        boolean mUseIncSupp = rs.isUseNative() && Build.VERSION.SDK_INT < 19;
        long id = rs.nScriptIntrinsicCreate(3, e.getID(rs), mUseIncSupp);
        ScriptIntrinsicLUT si = new ScriptIntrinsicLUT(id, rs);
        si.setIncSupp(mUseIncSupp);
        si.mTables = Allocation.createSized(rs, Element.U8(rs), 1024);
        for (int ct = 0; ct < 256; ++ct) {
            si.mCache[ct] = (byte)ct;
            si.mCache[ct + 256] = (byte)ct;
            si.mCache[ct + 512] = (byte)ct;
            si.mCache[ct + 768] = (byte)ct;
        }
        si.setVar(0, si.mTables);
        return si;
    }

    private void validate(int index, int value) {
        if (index < 0 || index > 255) {
            throw new RSIllegalArgumentException("Index out of range (0-255).");
        }
        if (value < 0 || value > 255) {
            throw new RSIllegalArgumentException("Value out of range (0-255).");
        }
    }

    public void setRed(int index, int value) {
        this.validate(index, value);
        this.mCache[index] = (byte)value;
        this.mDirty = true;
    }

    public void setGreen(int index, int value) {
        this.validate(index, value);
        this.mCache[index + 256] = (byte)value;
        this.mDirty = true;
    }

    public void setBlue(int index, int value) {
        this.validate(index, value);
        this.mCache[index + 512] = (byte)value;
        this.mDirty = true;
    }

    public void setAlpha(int index, int value) {
        this.validate(index, value);
        this.mCache[index + 768] = (byte)value;
        this.mDirty = true;
    }

    public void forEach(Allocation ain, Allocation aout) {
        if (this.mDirty) {
            this.mDirty = false;
            this.mTables.copyFromUnchecked(this.mCache);
        }
        this.forEach(0, ain, aout, null);
    }

    public Script.KernelID getKernelID() {
        return this.createKernelID(0, 3, null, null);
    }
}

