/*
 * Decompiled with CFR 0.152.
 */
package android.support.v8.renderscript;

import android.renderscript.Script;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.BaseObj;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.FieldPacker;
import android.support.v8.renderscript.RSDriverException;
import android.support.v8.renderscript.RSIllegalArgumentException;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.Type;
import android.util.SparseArray;
import java.io.UnsupportedEncodingException;

public class Script
extends BaseObj {
    private boolean mUseIncSupp = false;
    private final SparseArray<KernelID> mKIDs = new SparseArray();
    private final SparseArray<InvokeID> mIIDs = new SparseArray();
    private final SparseArray<FieldID> mFIDs = new SparseArray();

    protected void setIncSupp(boolean useInc) {
        this.mUseIncSupp = useInc;
    }

    protected boolean isIncSupp() {
        return this.mUseIncSupp;
    }

    long getDummyAlloc(Allocation ain) {
        long dInElement = 0L;
        long dInType = 0L;
        long dummyAlloc = 0L;
        if (ain != null) {
            Type inType = ain.getType();
            dInElement = inType.getElement().getDummyElement(this.mRS);
            dInType = inType.getDummyType(this.mRS, dInElement);
            int xBytesSize = inType.getX() * inType.getElement().getBytesSize();
            dummyAlloc = this.mRS.nIncAllocationCreateTyped(ain.getID(this.mRS), dInType, xBytesSize);
            ain.setIncAllocID(dummyAlloc);
        }
        return dummyAlloc;
    }

    protected KernelID createKernelID(int slot, int sig, Element ein, Element eout) {
        KernelID k = (KernelID)this.mKIDs.get(slot);
        if (k != null) {
            return k;
        }
        long id = this.mRS.nScriptKernelIDCreate(this.getID(this.mRS), slot, sig, this.mUseIncSupp);
        if (id == 0L) {
            throw new RSDriverException("Failed to create KernelID");
        }
        k = new KernelID(id, this.mRS, this, slot, sig);
        this.mKIDs.put(slot, (Object)k);
        return k;
    }

    protected InvokeID createInvokeID(int slot) {
        InvokeID i = (InvokeID)this.mIIDs.get(slot);
        if (i != null) {
            return i;
        }
        long id = this.mRS.nScriptInvokeIDCreate(this.getID(this.mRS), slot);
        if (id == 0L) {
            throw new RSDriverException("Failed to create KernelID");
        }
        i = new InvokeID(id, this.mRS, this, slot);
        this.mIIDs.put(slot, (Object)i);
        return i;
    }

    protected FieldID createFieldID(int slot, Element e) {
        FieldID f = (FieldID)this.mFIDs.get(slot);
        if (f != null) {
            return f;
        }
        long id = this.mRS.nScriptFieldIDCreate(this.getID(this.mRS), slot, this.mUseIncSupp);
        if (id == 0L) {
            throw new RSDriverException("Failed to create FieldID");
        }
        f = new FieldID(id, this.mRS, this, slot);
        this.mFIDs.put(slot, (Object)f);
        return f;
    }

    protected void invoke(int slot) {
        this.mRS.nScriptInvoke(this.getID(this.mRS), slot, this.mUseIncSupp);
    }

    protected void invoke(int slot, FieldPacker v) {
        if (v != null) {
            this.mRS.nScriptInvokeV(this.getID(this.mRS), slot, v.getData(), this.mUseIncSupp);
        } else {
            this.mRS.nScriptInvoke(this.getID(this.mRS), slot, this.mUseIncSupp);
        }
    }

    public void bindAllocation(Allocation va, int slot) {
        this.mRS.validate();
        if (va != null) {
            this.mRS.nScriptBindAllocation(this.getID(this.mRS), va.getID(this.mRS), slot, this.mUseIncSupp);
        } else {
            this.mRS.nScriptBindAllocation(this.getID(this.mRS), 0L, slot, this.mUseIncSupp);
        }
    }

    public void setTimeZone(String timeZone) {
        this.mRS.validate();
        try {
            this.mRS.nScriptSetTimeZone(this.getID(this.mRS), timeZone.getBytes("UTF-8"), this.mUseIncSupp);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected void forEach(int slot, Allocation ain, Allocation aout, FieldPacker v) {
        if (ain == null && aout == null) {
            throw new RSIllegalArgumentException("At least one of ain or aout is required to be non-null.");
        }
        long in_id = 0L;
        long out_id = 0L;
        if (ain != null) {
            in_id = ain.getID(this.mRS);
        }
        if (aout != null) {
            out_id = aout.getID(this.mRS);
        }
        byte[] params = null;
        if (v != null) {
            params = v.getData();
        }
        if (this.mUseIncSupp) {
            long ainInc = this.getDummyAlloc(ain);
            long aoutInc = this.getDummyAlloc(aout);
            this.mRS.nScriptForEach(this.getID(this.mRS), slot, ainInc, aoutInc, params, this.mUseIncSupp);
        } else {
            this.mRS.nScriptForEach(this.getID(this.mRS), slot, in_id, out_id, params, this.mUseIncSupp);
        }
    }

    protected void forEach(int slot, Allocation ain, Allocation aout, FieldPacker v, LaunchOptions sc) {
        if (ain == null && aout == null) {
            throw new RSIllegalArgumentException("At least one of ain or aout is required to be non-null.");
        }
        if (sc == null) {
            this.forEach(slot, ain, aout, v);
            return;
        }
        long in_id = 0L;
        long out_id = 0L;
        if (ain != null) {
            in_id = ain.getID(this.mRS);
        }
        if (aout != null) {
            out_id = aout.getID(this.mRS);
        }
        byte[] params = null;
        if (v != null) {
            params = v.getData();
        }
        if (this.mUseIncSupp) {
            long ainInc = this.getDummyAlloc(ain);
            long aoutInc = this.getDummyAlloc(aout);
            this.mRS.nScriptForEachClipped(this.getID(this.mRS), slot, ainInc, aoutInc, params, sc.xstart, sc.xend, sc.ystart, sc.yend, sc.zstart, sc.zend, this.mUseIncSupp);
        } else {
            this.mRS.nScriptForEachClipped(this.getID(this.mRS), slot, in_id, out_id, params, sc.xstart, sc.xend, sc.ystart, sc.yend, sc.zstart, sc.zend, this.mUseIncSupp);
        }
    }

    Script(long id, RenderScript rs) {
        super(id, rs);
    }

    protected void forEach(int slot, Allocation[] ains, Allocation aout, FieldPacker v) {
        this.forEach(slot, ains, aout, v, null);
    }

    protected void forEach(int slot, Allocation[] ains, Allocation aout, FieldPacker v, LaunchOptions sc) {
        long[] in_ids;
        this.mRS.validate();
        if (ains != null) {
            for (Allocation ain : ains) {
                this.mRS.validateObject(ain);
            }
        }
        this.mRS.validateObject(aout);
        if (ains == null && aout == null) {
            throw new RSIllegalArgumentException("At least one of ain or aout is required to be non-null.");
        }
        if (ains != null) {
            in_ids = new long[ains.length];
            for (int index = 0; index < ains.length; ++index) {
                in_ids[index] = ains[index].getID(this.mRS);
            }
        } else {
            in_ids = null;
        }
        long out_id = 0L;
        if (aout != null) {
            out_id = aout.getID(this.mRS);
        }
        byte[] params = null;
        if (v != null) {
            params = v.getData();
        }
        int[] limits = null;
        if (sc != null) {
            limits = new int[]{sc.xstart, sc.xend, sc.ystart, sc.yend, sc.zstart, sc.zend};
        }
        this.mRS.nScriptForEach(this.getID(this.mRS), slot, in_ids, out_id, params, limits);
    }

    protected void reduce(int slot, Allocation[] ains, Allocation aout, LaunchOptions sc) {
        this.mRS.validate();
        if (ains == null || ains.length < 1) {
            throw new RSIllegalArgumentException("At least one input is required.");
        }
        if (aout == null) {
            throw new RSIllegalArgumentException("aout is required to be non-null.");
        }
        for (Allocation ain : ains) {
            this.mRS.validateObject(ain);
        }
        long[] in_ids = new long[ains.length];
        for (int index = 0; index < ains.length; ++index) {
            in_ids[index] = ains[index].getID(this.mRS);
        }
        long out_id = aout.getID(this.mRS);
        int[] limits = null;
        if (sc != null) {
            limits = new int[]{sc.xstart, sc.xend, sc.ystart, sc.yend, sc.zstart, sc.zend};
        }
        this.mRS.nScriptReduce(this.getID(this.mRS), slot, in_ids, out_id, limits);
    }

    public void setVar(int index, float v) {
        this.mRS.nScriptSetVarF(this.getID(this.mRS), index, v, this.mUseIncSupp);
    }

    public void setVar(int index, double v) {
        this.mRS.nScriptSetVarD(this.getID(this.mRS), index, v, this.mUseIncSupp);
    }

    public void setVar(int index, int v) {
        this.mRS.nScriptSetVarI(this.getID(this.mRS), index, v, this.mUseIncSupp);
    }

    public void setVar(int index, long v) {
        this.mRS.nScriptSetVarJ(this.getID(this.mRS), index, v, this.mUseIncSupp);
    }

    public void setVar(int index, boolean v) {
        this.mRS.nScriptSetVarI(this.getID(this.mRS), index, v ? 1 : 0, this.mUseIncSupp);
    }

    public void setVar(int index, BaseObj o) {
        if (this.mUseIncSupp) {
            long oInc = this.getDummyAlloc((Allocation)o);
            this.mRS.nScriptSetVarObj(this.getID(this.mRS), index, o == null ? 0L : oInc, this.mUseIncSupp);
        } else {
            this.mRS.nScriptSetVarObj(this.getID(this.mRS), index, o == null ? 0L : o.getID(this.mRS), this.mUseIncSupp);
        }
    }

    public void setVar(int index, FieldPacker v) {
        this.mRS.nScriptSetVarV(this.getID(this.mRS), index, v.getData(), this.mUseIncSupp);
    }

    public void setVar(int index, FieldPacker v, Element e, int[] dims) {
        if (this.mUseIncSupp) {
            long dElement = e.getDummyElement(this.mRS);
            this.mRS.nScriptSetVarVE(this.getID(this.mRS), index, v.getData(), dElement, dims, this.mUseIncSupp);
        } else {
            this.mRS.nScriptSetVarVE(this.getID(this.mRS), index, v.getData(), e.getID(this.mRS), dims, this.mUseIncSupp);
        }
    }

    public static final class LaunchOptions {
        private int xstart = 0;
        private int ystart = 0;
        private int xend = 0;
        private int yend = 0;
        private int zstart = 0;
        private int zend = 0;
        private int strategy;

        public LaunchOptions setX(int xstartArg, int xendArg) {
            if (xstartArg < 0 || xendArg <= xstartArg) {
                throw new RSIllegalArgumentException("Invalid dimensions");
            }
            this.xstart = xstartArg;
            this.xend = xendArg;
            return this;
        }

        public LaunchOptions setY(int ystartArg, int yendArg) {
            if (ystartArg < 0 || yendArg <= ystartArg) {
                throw new RSIllegalArgumentException("Invalid dimensions");
            }
            this.ystart = ystartArg;
            this.yend = yendArg;
            return this;
        }

        public LaunchOptions setZ(int zstartArg, int zendArg) {
            if (zstartArg < 0 || zendArg <= zstartArg) {
                throw new RSIllegalArgumentException("Invalid dimensions");
            }
            this.zstart = zstartArg;
            this.zend = zendArg;
            return this;
        }

        public int getXStart() {
            return this.xstart;
        }

        public int getXEnd() {
            return this.xend;
        }

        public int getYStart() {
            return this.ystart;
        }

        public int getYEnd() {
            return this.yend;
        }

        public int getZStart() {
            return this.zstart;
        }

        public int getZEnd() {
            return this.zend;
        }
    }

    public static class FieldBase {
        protected Element mElement;
        protected Allocation mAllocation;

        protected void init(RenderScript rs, int dimx) {
            this.mAllocation = Allocation.createSized(rs, this.mElement, dimx, 1);
        }

        protected void init(RenderScript rs, int dimx, int usages) {
            this.mAllocation = Allocation.createSized(rs, this.mElement, dimx, 1 | usages);
        }

        protected FieldBase() {
        }

        public Element getElement() {
            return this.mElement;
        }

        public Type getType() {
            return this.mAllocation.getType();
        }

        public Allocation getAllocation() {
            return this.mAllocation;
        }

        public void updateAllocation() {
        }
    }

    public static class Builder {
        RenderScript mRS;

        Builder(RenderScript rs) {
            this.mRS = rs;
        }
    }

    public static final class FieldID
    extends BaseObj {
        Script.FieldID mN;
        Script mScript;
        int mSlot;

        FieldID(long id, RenderScript rs, Script s, int slot) {
            super(id, rs);
            this.mScript = s;
            this.mSlot = slot;
        }
    }

    public static final class InvokeID
    extends BaseObj {
        Script mScript;
        int mSlot;

        InvokeID(long id, RenderScript rs, Script s, int slot) {
            super(id, rs);
            this.mScript = s;
            this.mSlot = slot;
        }
    }

    public static final class KernelID
    extends BaseObj {
        Script.KernelID mN;
        Script mScript;
        int mSlot;
        int mSig;

        KernelID(long id, RenderScript rs, Script s, int slot, int sig) {
            super(id, rs);
            this.mScript = s;
            this.mSlot = slot;
            this.mSig = sig;
        }
    }
}

