/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import org.conscrypt.HpkeSpi;

public class DuckTypedHpkeSpi
implements HpkeSpi {
    private final Object delegate;
    private final Map<String, Method> methods = new HashMap<String, Method>();

    private DuckTypedHpkeSpi(Object delegate) throws NoSuchMethodException {
        this.delegate = delegate;
        Class<?> sourceClass = delegate.getClass();
        for (Method targetMethod : HpkeSpi.class.getMethods()) {
            if (targetMethod.isSynthetic()) continue;
            Method sourceMethod = sourceClass.getMethod(targetMethod.getName(), targetMethod.getParameterTypes());
            Class<?> sourceReturnType = sourceMethod.getReturnType();
            Class<?> targetReturnType = targetMethod.getReturnType();
            if (!targetReturnType.isAssignableFrom(sourceReturnType)) {
                throw new NoSuchMethodException(sourceMethod + " return value (" + sourceReturnType + ") incompatible with target return value (" + targetReturnType + ")");
            }
            this.methods.put(sourceMethod.getName(), sourceMethod);
        }
    }

    public static DuckTypedHpkeSpi newInstance(Object delegate) {
        try {
            return new DuckTypedHpkeSpi(delegate);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private Object invoke(String methodName, Object ... args) throws InvocationTargetException {
        Method method = this.methods.get(methodName);
        if (method == null) {
            throw new IllegalStateException("DuckTypedHpkSpi internal error");
        }
        try {
            return method.invoke(this.delegate, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("DuckTypedHpkSpi internal error", e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    private void invokeWithPossibleInvalidKey(String methodName, Object ... args) throws InvalidKeyException {
        try {
            this.invoke(methodName, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvalidKeyException) {
                throw (InvalidKeyException)cause;
            }
            throw new IllegalStateException(cause);
        }
    }

    private Object invokeWithPossibleGeneralSecurity(String methodName, Object ... args) throws GeneralSecurityException {
        try {
            return this.invoke(methodName, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof GeneralSecurityException) {
                throw (GeneralSecurityException)cause;
            }
            throw new IllegalStateException(cause);
        }
    }

    private Object invokeNoChecked(String methodName, Object ... args) {
        try {
            return this.invoke(methodName, args);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    public Object getDelegate() {
        return this.delegate;
    }

    @Override
    public void engineInitSender(PublicKey recipientKey, byte[] info, PrivateKey senderKey, byte[] psk, byte[] pskId) throws InvalidKeyException {
        this.invokeWithPossibleInvalidKey("engineInitSender", recipientKey, info, senderKey, psk, pskId);
    }

    @Override
    public void engineInitSenderForTesting(PublicKey recipientKey, byte[] info, PrivateKey senderKey, byte[] psk, byte[] pskId, byte[] sKe) throws InvalidKeyException {
        this.invokeWithPossibleInvalidKey("engineInitSenderForTesting", recipientKey, info, senderKey, psk, pskId, sKe);
    }

    @Override
    public void engineInitRecipient(byte[] encapsulated, PrivateKey key, byte[] info, PublicKey senderKey, byte[] psk, byte[] psk_id) throws InvalidKeyException {
        this.invokeWithPossibleInvalidKey("engineInitRecipient", encapsulated, key, info, senderKey, psk, psk_id);
    }

    @Override
    public byte[] engineSeal(byte[] plaintext, byte[] aad) {
        return (byte[])this.invokeNoChecked("engineSeal", plaintext, aad);
    }

    @Override
    public byte[] engineExport(int length, byte[] exporterContext) {
        return (byte[])this.invokeNoChecked("engineExport", length, exporterContext);
    }

    @Override
    public byte[] engineOpen(byte[] ciphertext, byte[] aad) throws GeneralSecurityException {
        return (byte[])this.invokeWithPossibleGeneralSecurity("engineOpen", ciphertext, aad);
    }

    @Override
    public byte[] getEncapsulated() {
        return (byte[])this.invokeNoChecked("getEncapsulated", new Object[0]);
    }
}

