/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import org.conscrypt.HpkeContext;
import org.conscrypt.HpkeSpi;

public class HpkeContextSender
extends HpkeContext {
    private HpkeContextSender(HpkeSpi spi) {
        super(spi);
    }

    public byte[] getEncapsulated() {
        return this.spi.getEncapsulated();
    }

    public byte[] seal(byte[] plaintext, byte[] aad) {
        return this.spi.engineSeal(plaintext, aad);
    }

    public static HpkeContextSender getInstance(String suite) throws NoSuchAlgorithmException {
        return new HpkeContextSender(HpkeContextSender.findSpi(suite));
    }

    public static HpkeContextSender getInstance(String suite, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return new HpkeContextSender(HpkeContextSender.findSpi(suite, providerName));
    }

    public static HpkeContextSender getInstance(String suite, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return new HpkeContextSender(HpkeContextSender.findSpi(suite, provider));
    }

    public void init(PublicKey recipientKey, byte[] info) throws InvalidKeyException {
        this.spi.engineInitSender(recipientKey, info, null, HpkeSpi.DEFAULT_PSK, HpkeSpi.DEFAULT_PSK_ID);
    }

    public void init(PublicKey recipientKey, byte[] info, PrivateKey senderKey) throws InvalidKeyException {
        if (senderKey == null) {
            throw new InvalidKeyException("Sender private key is null");
        }
        this.spi.engineInitSender(recipientKey, info, senderKey, HpkeSpi.DEFAULT_PSK, HpkeSpi.DEFAULT_PSK_ID);
    }

    public void init(PublicKey recipientKey, byte[] info, byte[] psk, byte[] psk_id) throws InvalidKeyException {
        this.spi.engineInitSender(recipientKey, info, null, psk, psk_id);
    }

    public void init(PublicKey recipientKey, byte[] info, PrivateKey senderKey, byte[] psk, byte[] psk_id) throws InvalidKeyException {
        if (senderKey == null) {
            throw new InvalidKeyException("Sender private key is null");
        }
        this.spi.engineInitSender(recipientKey, info, senderKey, psk, psk_id);
    }

    public void initForTesting(PublicKey recipientKey, byte[] info, byte[] sKe) throws InvalidKeyException {
        if (sKe == null) {
            throw new IllegalArgumentException("null seed");
        }
        this.spi.engineInitSenderForTesting(recipientKey, info, null, HpkeSpi.DEFAULT_PSK, HpkeSpi.DEFAULT_PSK, sKe);
    }
}

