/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.metrics;

import org.conscrypt.CertBlocklistEntry;
import org.conscrypt.Platform;
import org.conscrypt.ct.LogStore;
import org.conscrypt.ct.PolicyCompliance;
import org.conscrypt.ct.VerificationResult;
import org.conscrypt.metrics.CertificateTransparencyVerificationReason;
import org.conscrypt.metrics.CipherSuite;
import org.conscrypt.metrics.ConscryptStatsLog;
import org.conscrypt.metrics.Protocol;
import org.conscrypt.metrics.ReflexiveStatsEvent;
import org.conscrypt.metrics.ReflexiveStatsLog;
import org.conscrypt.metrics.StatsLog;

public final class StatsLogImpl
implements StatsLog {
    private static final StatsLog INSTANCE = new StatsLogImpl();
    private static final boolean sdkVersionBiggerThan32 = Platform.isSdkGreater(32);

    private StatsLogImpl() {
    }

    public static StatsLog getInstance() {
        return INSTANCE;
    }

    @Override
    public void countTlsHandshake(boolean success, String protocol, String cipherSuite, long duration) {
        Protocol proto = Protocol.forName(protocol);
        CipherSuite suite = CipherSuite.forName(cipherSuite);
        this.write(317, success, proto.getId(), suite.getId(), (int)duration, Platform.getStatsSource().getId(), Platform.getUids());
    }

    private static int logStoreStateToMetricsState(LogStore.State state) {
        switch (state) {
            case UNINITIALIZED: 
            case LOADED: {
                return 0;
            }
            case NOT_FOUND: {
                return 2;
            }
            case MALFORMED: {
                return 3;
            }
            case COMPLIANT: {
                return 1;
            }
            case NON_COMPLIANT: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public void updateCTLogListStatusChanged(LogStore logStore) {
        int state = StatsLogImpl.logStoreStateToMetricsState(logStore.getState());
        this.write(934, state, logStore.getCompatVersion(), logStore.getMinCompatVersionAvailable(), logStore.getMajorVersion(), logStore.getMinorVersion());
    }

    private static int policyComplianceToMetrics(VerificationResult result, PolicyCompliance compliance) {
        if (compliance == PolicyCompliance.COMPLY) {
            return 1;
        }
        if (result.getValidSCTs().size() == 0) {
            return 3;
        }
        if (compliance == PolicyCompliance.NOT_ENOUGH_SCTS || compliance == PolicyCompliance.NOT_ENOUGH_DIVERSE_SCTS || compliance == PolicyCompliance.NO_RFC6962_LOG) {
            return 4;
        }
        return 0;
    }

    private static int getUid() {
        int[] uids = Platform.getUids();
        if (uids != null && uids.length != 0) {
            return uids[0];
        }
        return 0;
    }

    @Override
    public void reportCTVerificationResult(LogStore store, VerificationResult result, PolicyCompliance compliance, CertificateTransparencyVerificationReason reason) {
        if (store.getState() == LogStore.State.NOT_FOUND || store.getState() == LogStore.State.MALFORMED) {
            this.write(989, 5, reason.getId(), 0, 0, 0, 0, 0, 0, StatsLogImpl.getUid());
        } else if (store.getState() == LogStore.State.NON_COMPLIANT) {
            this.write(989, 6, reason.getId(), 0, 0, 0, 0, 0, 0, StatsLogImpl.getUid());
        } else if (store.getState() == LogStore.State.COMPLIANT) {
            int comp = StatsLogImpl.policyComplianceToMetrics(result, compliance);
            this.write(989, comp, reason.getId(), store.getCompatVersion(), store.getMajorVersion(), store.getMinorVersion(), result.numCertSCTs(), result.numOCSPSCTs(), result.numTlsSCTs(), StatsLogImpl.getUid());
        }
    }

    private static int blocklistOriginToMetrics(CertBlocklistEntry.Origin origin) {
        switch (origin) {
            case SHA1_TEST: {
                return 1;
            }
            case SHA1_BUILT_IN: {
                return 2;
            }
            case SHA1_FILE: {
                return 3;
            }
            case SHA256_TEST: {
                return 4;
            }
            case SHA256_BUILT_IN: {
                return 5;
            }
            case SHA256_FILE: {
                return 6;
            }
        }
        return 0;
    }

    @Override
    public void reportBlocklistHit(CertBlocklistEntry entry) {
        this.write(1143, StatsLogImpl.blocklistOriginToMetrics(entry.getOrigin()), entry.getIndex(), StatsLogImpl.getUid());
    }

    private void write(int atomId, boolean success, int protocol, int cipherSuite, int duration, int source, int[] uids) {
        if (!sdkVersionBiggerThan32) {
            ReflexiveStatsEvent.Builder builder = ReflexiveStatsEvent.newBuilder();
            builder.writeInt(atomId);
            builder.writeBoolean(success);
            builder.writeInt(protocol);
            builder.writeInt(cipherSuite);
            builder.writeInt(duration);
            builder.writeInt(source);
            builder.usePooledBuffer();
            ReflexiveStatsLog.write(builder.build());
        } else {
            ConscryptStatsLog.write(atomId, success, protocol, cipherSuite, duration, source, uids);
        }
    }

    private void write(int atomId, int status, int loadedCompatVersion, int minCompatVersionAvailable, int majorVersion, int minorVersion) {
        ConscryptStatsLog.write(atomId, status, loadedCompatVersion, minCompatVersionAvailable, majorVersion, minorVersion);
    }

    private void write(int atomId, int verificationResult, int verificationReason, int policyCompatVersion, int majorVersion, int minorVersion, int numEmbeddedScts, int numOcspScts, int numTlsScts, int uid) {
        ConscryptStatsLog.write(atomId, verificationResult, verificationReason, policyCompatVersion, majorVersion, minorVersion, numEmbeddedScts, numOcspScts, numTlsScts, uid);
    }

    private void write(int atomId, int origin, int index, int uid) {
        ConscryptStatsLog.write(atomId, origin, index, uid);
    }
}

