# -*- coding: utf-8 -*-
# Generated by Django 1.11.7 on 2017-12-12 18:56
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ('main', '0016_v330_non_blank_workflow'),
    ]

    operations = [
        migrations.AlterField(
            model_name='unifiedjob',
            name='result_stdout_text',
            field=models.TextField(editable=False, null=True),
        ),
        # Using SeparateDatabaseAndState here allows us to update the migration
        # state so that Django thinks the UnifiedJob.result_stdout_text field
        # is gone _without_ actually deleting the underlying column/data
        migrations.SeparateDatabaseAndState(
            state_operations=[
                migrations.RemoveField(
                    model_name='unifiedjob',
                    name='result_stdout_text',
                ),
            ]
        ),
        # On other side of the equation, this migration introduces a new model
        # which is *unmanaged* (meaning, a new table is not created for it);
        # instead, this sort of "virtual" model is used to maintain an ORM
        # reference to the actual `main_unifiedjob.result_stdout_text` column
        migrations.CreateModel(
            name='UnifiedJobDeprecatedStdout',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('result_stdout_text', models.TextField(editable=False, null=True)),
            ],
            options={
                'db_table': 'main_unifiedjob',
                'managed': False,
            },
        ),
    ]
