# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2019-02-19 04:27
from __future__ import unicode_literals

from django.db import migrations, models

from awx.main.models import CredentialType
from awx.main.utils.common import set_current_apps


def migrate_to_static_inputs(apps, schema_editor):
    set_current_apps(apps)
    CredentialType.setup_tower_managed_defaults(apps)


class Migration(migrations.Migration):
    dependencies = [
        ('main', '0060_v350_update_schedule_uniqueness_constraint'),
    ]

    operations = [
        migrations.AddField(
            model_name='credentialtype',
            name='namespace',
            field=models.CharField(default=None, editable=False, max_length=1024, null=True),
        ),
        migrations.RunPython(migrate_to_static_inputs),
    ]
