# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2019-05-06 13:49
from __future__ import unicode_literals

from django.db import migrations


def create_through_relations(apps, schema_editor):
    relations = [
        [
            'UnifiedJobTemplate',
            apps.get_model('main', 'UnifiedJobTemplateInstanceGroupMembership'),
        ],
        [
            'Organization',
            apps.get_model('main', 'OrganizationInstanceGroupMembership'),
        ],
        [
            'Inventory',
            apps.get_model('main', 'InventoryInstanceGroupMembership'),
        ],
    ]
    for cls, Membership in relations:
        Target = apps.get_model('main', cls)
        for x in Target.objects.iterator():
            for i, instance_group in enumerate(x.instance_groups.all()):
                Membership(instancegroup=instance_group, position=i, **{'%s' % cls.lower(): x}).save()


class Migration(migrations.Migration):
    dependencies = [
        ('main', '0073_v360_create_instance_group_m2m'),
    ]

    operations = [migrations.RunPython(create_through_relations)]
