# Generated by Django 2.2.8 on 2020-02-21 16:31

from django.db import migrations, models, connection

from ._sqlite_helper import dbawaremigrations


def migrate_event_data(apps, schema_editor):
    # see: https://github.com/ansible/awx/issues/6010
    #
    # the goal of this function is to end with event tables (e.g., main_jobevent)
    # that have a bigint primary key (because the old usage of an integer
    # numeric isn't enough, as its range is about 2.1B, see:
    # https://www.postgresql.org/docs/9.1/datatype-numeric.html)
    for tblname in ('main_jobevent', 'main_inventoryupdateevent', 'main_projectupdateevent', 'main_adhoccommandevent', 'main_systemjobevent'):
        with connection.cursor() as cursor:
            # This loop used to do roughly the following:
            #     Rename the table to _old_<tablename>
            #     Create a new table form the old table (it would have no rows)
            #     Drop the old sequnce and create a new on tied to the new table and set the sequence to the last number from the old table
            # This used to work with postgres spitting out a NOTICE and DETAIL
            # With the django 4.2 upgrade that changed to an ERROR and HINT
            # By the time we hit the 4.2 upgrade, no one should be upgrading a database this old directly to this new schema
            # So we no longer really care about having to do all of this work, we only need a table with a bigint ID field
            # And this can be achieved by just changing the id column type...
            cursor.execute(f'ALTER TABLE {tblname} ALTER COLUMN id TYPE bigint USING id::bigint;')


def migrate_event_data_sqlite(apps, schema_editor):
    # TODO: cmeyers fill this in
    return


class FakeAlterField(migrations.AlterField):
    def database_forwards(self, *args):
        # this is intentionally left blank, because we're
        # going to accomplish the migration with some custom raw SQL
        pass


class Migration(migrations.Migration):
    dependencies = [
        ('main', '0112_v370_workflow_node_identifier'),
    ]

    operations = [
        dbawaremigrations.RunPython(migrate_event_data, sqlite_code=migrate_event_data_sqlite),
        FakeAlterField(
            model_name='adhoccommandevent',
            name='id',
            field=models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
        ),
        FakeAlterField(
            model_name='inventoryupdateevent',
            name='id',
            field=models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
        ),
        FakeAlterField(
            model_name='jobevent',
            name='id',
            field=models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
        ),
        FakeAlterField(
            model_name='projectupdateevent',
            name='id',
            field=models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
        ),
        FakeAlterField(
            model_name='systemjobevent',
            name='id',
            field=models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID'),
        ),
    ]
