# Generated by Django 2.2.11 on 2020-04-03 00:11

from django.db import migrations, models


def remove_manual_inventory_sources(apps, schema_editor):
    """Previously we would automatically create inventory sources after
    Group creation and we would use the parent Group as our interface for the user.
    During that process we would create InventorySource that had a source of "manual".
    """
    InventoryUpdate = apps.get_model('main', 'InventoryUpdate')
    InventoryUpdate.objects.filter(source='').delete()
    InventorySource = apps.get_model('main', 'InventorySource')
    InventorySource.objects.filter(source='').delete()


class Migration(migrations.Migration):
    dependencies = [
        ('main', '0113_v370_event_bigint'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='inventorysource',
            name='deprecated_group',
        ),
        migrations.RunPython(remove_manual_inventory_sources),
        migrations.AlterField(
            model_name='inventorysource',
            name='source',
            field=models.CharField(
                choices=[
                    ('file', 'File, Directory or Script'),
                    ('scm', 'Sourced from a Project'),
                    ('ec2', 'Amazon EC2'),
                    ('gce', 'Google Compute Engine'),
                    ('azure_rm', 'Microsoft Azure Resource Manager'),
                    ('vmware', 'VMware vCenter'),
                    ('satellite6', 'Red Hat Satellite 6'),
                    ('cloudforms', 'Red Hat CloudForms'),
                    ('openstack', 'OpenStack'),
                    ('rhv', 'Red Hat Virtualization'),
                    ('tower', 'Ansible Tower'),
                    ('custom', 'Custom Script'),
                ],
                default=None,
                max_length=32,
            ),
        ),
        migrations.AlterField(
            model_name='inventoryupdate',
            name='source',
            field=models.CharField(
                choices=[
                    ('file', 'File, Directory or Script'),
                    ('scm', 'Sourced from a Project'),
                    ('ec2', 'Amazon EC2'),
                    ('gce', 'Google Compute Engine'),
                    ('azure_rm', 'Microsoft Azure Resource Manager'),
                    ('vmware', 'VMware vCenter'),
                    ('satellite6', 'Red Hat Satellite 6'),
                    ('cloudforms', 'Red Hat CloudForms'),
                    ('openstack', 'OpenStack'),
                    ('rhv', 'Red Hat Virtualization'),
                    ('tower', 'Ansible Tower'),
                    ('custom', 'Custom Script'),
                ],
                default=None,
                max_length=32,
            ),
        ),
    ]
