# Generated by Django 2.2.11 on 2020-05-19 02:27

from django.db import migrations, models


def remove_hipchat_notifications(apps, schema_editor):
    """
    HipChat notifications are no longer in service, remove any that are found.
    """
    Notification = apps.get_model('main', 'Notification')
    Notification.objects.filter(notification_type='hipchat').delete()
    NotificationTemplate = apps.get_model('main', 'NotificationTemplate')
    NotificationTemplate.objects.filter(notification_type='hipchat').delete()


class Migration(migrations.Migration):
    dependencies = [
        ('main', '0115_v370_schedule_set_null'),
    ]

    operations = [
        migrations.RunPython(remove_hipchat_notifications),
        migrations.AlterField(
            model_name='notification',
            name='notification_type',
            field=models.CharField(
                choices=[
                    ('email', 'Email'),
                    ('grafana', 'Grafana'),
                    ('irc', 'IRC'),
                    ('mattermost', 'Mattermost'),
                    ('pagerduty', 'Pagerduty'),
                    ('rocketchat', 'Rocket.Chat'),
                    ('slack', 'Slack'),
                    ('twilio', 'Twilio'),
                    ('webhook', 'Webhook'),
                ],
                max_length=32,
            ),
        ),
        migrations.AlterField(
            model_name='notificationtemplate',
            name='notification_type',
            field=models.CharField(
                choices=[
                    ('email', 'Email'),
                    ('grafana', 'Grafana'),
                    ('irc', 'IRC'),
                    ('mattermost', 'Mattermost'),
                    ('pagerduty', 'Pagerduty'),
                    ('rocketchat', 'Rocket.Chat'),
                    ('slack', 'Slack'),
                    ('twilio', 'Twilio'),
                    ('webhook', 'Webhook'),
                ],
                max_length=32,
            ),
        ),
    ]
