# Generated by Django 2.2.11 on 2020-07-20 19:56

import logging
import yaml

from django.db import migrations, models

from awx.main.models.base import VarsDictProperty

from ._inventory_source_vars import FrozenInjectors


logger = logging.getLogger('awx.main.migrations')


def _get_inventory_sources(InventorySource):
    return InventorySource.objects.filter(source__in=['ec2', 'gce', 'azure_rm', 'vmware', 'satellite6', 'openstack', 'rhv', 'tower'])


def inventory_source_vars_forward(apps, schema_editor):
    InventorySource = apps.get_model("main", "InventorySource")
    '''
    The Django app registry does not keep track of model inheritance. The
    source_vars_dict property comes from InventorySourceOptions via inheritance.
    This adds that property. Luckily, other properteries and functionality from
    InventorySourceOptions is not needed by the injector logic.
    '''
    setattr(InventorySource, 'source_vars_dict', VarsDictProperty('source_vars'))
    source_vars_backup = dict()

    for inv_source_obj in _get_inventory_sources(InventorySource):
        if inv_source_obj.source in FrozenInjectors:
            source_vars_backup[inv_source_obj.id] = dict(inv_source_obj.source_vars_dict)

            injector = FrozenInjectors[inv_source_obj.source]()
            new_inv_source_vars = injector.inventory_as_dict(inv_source_obj, None)
            inv_source_obj.source_vars = yaml.dump(new_inv_source_vars)
            inv_source_obj.save()


class Migration(migrations.Migration):
    dependencies = [
        ('main', '0118_add_remote_archive_scm_type'),
    ]

    operations = [
        migrations.RunPython(inventory_source_vars_forward),
        migrations.RemoveField(
            model_name='inventorysource',
            name='group_by',
        ),
        migrations.RemoveField(
            model_name='inventoryupdate',
            name='group_by',
        ),
        migrations.RemoveField(
            model_name='inventorysource',
            name='instance_filters',
        ),
        migrations.RemoveField(
            model_name='inventoryupdate',
            name='instance_filters',
        ),
        migrations.RemoveField(
            model_name='inventorysource',
            name='source_regions',
        ),
        migrations.RemoveField(
            model_name='inventoryupdate',
            name='source_regions',
        ),
        migrations.AddField(
            model_name='inventorysource',
            name='enabled_value',
            field=models.TextField(
                blank=True,
                default='',
                help_text='Only used when enabled_var is set. Value when the host is considered enabled. For example if enabled_var="status.power_state"and enabled_value="powered_on" with host variables:{   "status": {     "power_state": "powered_on",     "created": "2020-08-04T18:13:04+00:00",     "healthy": true    },    "name": "foobar",    "ip_address": "192.168.2.1"}The host would be marked enabled. If power_state where any value other than powered_on then the host would be disabled when imported into Tower. If the key is not found then the host will be enabled',
            ),
        ),
        migrations.AddField(
            model_name='inventorysource',
            name='enabled_var',
            field=models.TextField(
                blank=True,
                default='',
                help_text='Retrieve the enabled state from the given dict of host variables. The enabled variable may be specified as "foo.bar", in which case the lookup will traverse into nested dicts, equivalent to: from_dict.get("foo", {}).get("bar", default)',
            ),
        ),
        migrations.AddField(
            model_name='inventorysource',
            name='host_filter',
            field=models.TextField(blank=True, default='', help_text='Regex where only matching hosts will be imported into Tower.'),
        ),
        migrations.AddField(
            model_name='inventoryupdate',
            name='enabled_value',
            field=models.TextField(
                blank=True,
                default='',
                help_text='Only used when enabled_var is set. Value when the host is considered enabled. For example if enabled_var="status.power_state"and enabled_value="powered_on" with host variables:{   "status": {     "power_state": "powered_on",     "created": "2020-08-04T18:13:04+00:00",     "healthy": true    },    "name": "foobar",    "ip_address": "192.168.2.1"}The host would be marked enabled. If power_state where any value other than powered_on then the host would be disabled when imported into Tower. If the key is not found then the host will be enabled',
            ),
        ),
        migrations.AddField(
            model_name='inventoryupdate',
            name='enabled_var',
            field=models.TextField(
                blank=True,
                default='',
                help_text='Retrieve the enabled state from the given dict of host variables. The enabled variable may be specified as "foo.bar", in which case the lookup will traverse into nested dicts, equivalent to: from_dict.get("foo", {}).get("bar", default)',
            ),
        ),
        migrations.AddField(
            model_name='inventoryupdate',
            name='host_filter',
            field=models.TextField(blank=True, default='', help_text='Regex where only matching hosts will be imported into Tower.'),
        ),
    ]
