# Generated by Django 2.2.11 on 2020-08-04 15:19

import logging

import awx.main.fields

from django.db import migrations, models
import django.db.models.deletion

from awx.main.migrations import _galaxy as galaxy

logger = logging.getLogger('awx.main.migrations')


class Migration(migrations.Migration):
    dependencies = [
        ('main', '0119_inventory_plugins'),
    ]

    operations = [
        migrations.AlterField(
            model_name='credentialtype',
            name='kind',
            field=models.CharField(
                choices=[
                    ('ssh', 'Machine'),
                    ('vault', 'Vault'),
                    ('net', 'Network'),
                    ('scm', 'Source Control'),
                    ('cloud', 'Cloud'),
                    ('token', 'Personal Access Token'),
                    ('insights', 'Insights'),
                    ('external', 'External'),
                    ('kubernetes', 'Kubernetes'),
                    ('galaxy', 'Galaxy/Automation Hub'),
                ],
                max_length=32,
            ),
        ),
        migrations.CreateModel(
            name='OrganizationGalaxyCredentialMembership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.PositiveIntegerField(db_index=True, default=None, null=True)),
                ('credential', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.Credential')),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.Organization')),
            ],
        ),
        migrations.AddField(
            model_name='organization',
            name='galaxy_credentials',
            field=awx.main.fields.OrderedManyToManyField(
                blank=True, related_name='organization_galaxy_credentials', through='main.OrganizationGalaxyCredentialMembership', to='main.Credential'
            ),
        ),
        migrations.AddField(
            model_name='credential',
            name='managed_by_tower',
            field=models.BooleanField(default=False, editable=False),
        ),
        migrations.RunPython(galaxy.migrate_galaxy_settings),
    ]
