# Generated by Django 2.2.16 on 2020-11-19 16:20
import uuid

import awx.main.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    dependencies = [
        ('main', '0124_execution_environments'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='executionenvironment',
            options={'ordering': ('-created',)},
        ),
        migrations.AddField(
            model_name='executionenvironment',
            name='name',
            field=models.CharField(default=uuid.uuid4, max_length=512, unique=True),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='organization',
            name='execution_environment_admin_role',
            field=awx.main.fields.ImplicitRoleField(
                editable=False, null='True', on_delete=django.db.models.deletion.SET_NULL, parent_role='admin_role', related_name='+', to='main.Role'
            ),
            preserve_default='True',
        ),
        migrations.AddField(
            model_name='project',
            name='default_environment',
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text='The default execution environment for jobs run using this project.',
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name='+',
                to='main.ExecutionEnvironment',
            ),
        ),
        migrations.AlterField(
            model_name='credentialtype',
            name='kind',
            field=models.CharField(
                choices=[
                    ('ssh', 'Machine'),
                    ('vault', 'Vault'),
                    ('net', 'Network'),
                    ('scm', 'Source Control'),
                    ('cloud', 'Cloud'),
                    ('registry', 'Container Registry'),
                    ('token', 'Personal Access Token'),
                    ('insights', 'Insights'),
                    ('external', 'External'),
                    ('kubernetes', 'Kubernetes'),
                    ('galaxy', 'Galaxy/Automation Hub'),
                ],
                max_length=32,
            ),
        ),
        migrations.AlterUniqueTogether(
            name='executionenvironment',
            unique_together=set(),
        ),
    ]
