# Generated by Django 2.2.16 on 2021-03-13 14:53

from django.db import migrations, models


def migrate_existing_container_groups(apps, schema_editor):
    InstanceGroup = apps.get_model('main', 'InstanceGroup')

    for group in InstanceGroup.objects.filter(credential__isnull=False).iterator():
        group.is_container_group = True
        group.save(update_fields=['is_container_group'])


class Migration(migrations.Migration):
    dependencies = [
        ('main', '0131_undo_org_polymorphic_ee'),
    ]

    operations = [
        migrations.AddField(
            model_name='instancegroup',
            name='is_container_group',
            field=models.BooleanField(default=False),
        ),
        migrations.RunPython(migrate_existing_container_groups, migrations.RunPython.noop),
    ]
