# Generated by Django 2.2.16 on 2021-06-17 13:12
import logging

from django.db import migrations, models

from awx.main.models.credential import ManagedCredentialType, CredentialType as ModernCredentialType


logger = logging.getLogger(__name__)


def forwards(apps, schema_editor):
    InventoryUpdate = apps.get_model('main', 'InventoryUpdate')
    InventorySource = apps.get_model('main', 'InventorySource')

    r = InventoryUpdate.objects.filter(source='tower').update(source='controller')
    if r:
        logger.warning(f'Renamed {r} tower inventory updates to controller')
    InventorySource.objects.filter(source='tower').update(source='controller')
    if r:
        logger.warning(f'Renamed {r} tower inventory sources to controller')

    CredentialType = apps.get_model('main', 'CredentialType')

    tower_type = CredentialType.objects.filter(managed_by_tower=True, namespace='tower').first()
    if tower_type is not None:
        controller_type = CredentialType.objects.filter(managed_by_tower=True, namespace='controller', kind='cloud').first()
        if controller_type:
            # this gets created by prior migrations in upgrade scenarios
            controller_type.delete()

        registry_type = ManagedCredentialType.registry.get('controller')
        if not registry_type:
            raise RuntimeError('Excpected to find controller credential, this may need to be edited in the future!')
        logger.warning('Renaming the Ansible Tower credential type for existing install')
        tower_type.name = registry_type.name  # sensitive to translations
        tower_type.namespace = 'controller'  # if not done, will error setup_tower_managed_defaults
        tower_type.save(update_fields=['name', 'namespace'])

    ModernCredentialType.setup_tower_managed_defaults(apps)


def backwards(apps, schema_editor):
    InventoryUpdate = apps.get_model('main', 'InventoryUpdate')
    InventorySource = apps.get_model('main', 'InventorySource')

    r = InventoryUpdate.objects.filter(source='controller').update(source='tower')
    if r:
        logger.warning(f'Renamed {r} controller inventory updates to tower')
    r = InventorySource.objects.filter(source='controller').update(source='tower')
    if r:
        logger.warning(f'Renamed {r} controller inventory sources to tower')

    CredentialType = apps.get_model('main', 'CredentialType')

    tower_type = CredentialType.objects.filter(managed_by_tower=True, namespace='controller', kind='cloud').first()
    if tower_type is not None and not CredentialType.objects.filter(managed_by_tower=True, namespace='tower').exists():
        logger.info('Renaming the controller credential type back')
        tower_type.namespace = 'tower'
        tower_type.name = 'Ansible Tower'
        tower_type.save(update_fields=['namespace', 'name'])


class Migration(migrations.Migration):
    dependencies = [
        ('main', '0149_remove_inventory_insights_credential'),
    ]
    operations = [
        migrations.RunPython(migrations.RunPython.noop, backwards),
        migrations.AlterField(
            model_name='inventorysource',
            name='source',
            field=models.CharField(
                choices=[
                    ('file', 'File, Directory or Script'),
                    ('scm', 'Sourced from a Project'),
                    ('ec2', 'Amazon EC2'),
                    ('gce', 'Google Compute Engine'),
                    ('azure_rm', 'Microsoft Azure Resource Manager'),
                    ('vmware', 'VMware vCenter'),
                    ('satellite6', 'Red Hat Satellite 6'),
                    ('openstack', 'OpenStack'),
                    ('rhv', 'Red Hat Virtualization'),
                    ('controller', 'Red Hat Ansible Automation Platform'),
                    ('insights', 'Red Hat Insights'),
                ],
                default=None,
                max_length=32,
            ),
        ),
        migrations.AlterField(
            model_name='inventoryupdate',
            name='source',
            field=models.CharField(
                choices=[
                    ('file', 'File, Directory or Script'),
                    ('scm', 'Sourced from a Project'),
                    ('ec2', 'Amazon EC2'),
                    ('gce', 'Google Compute Engine'),
                    ('azure_rm', 'Microsoft Azure Resource Manager'),
                    ('vmware', 'VMware vCenter'),
                    ('satellite6', 'Red Hat Satellite 6'),
                    ('openstack', 'OpenStack'),
                    ('rhv', 'Red Hat Virtualization'),
                    ('controller', 'Red Hat Ansible Automation Platform'),
                    ('insights', 'Red Hat Insights'),
                ],
                default=None,
                max_length=32,
            ),
        ),
        migrations.RunPython(forwards, migrations.RunPython.noop),
    ]
