# Generated by Django 3.2.13 on 2022-08-02 17:53

import django.core.validators
from django.db import migrations, models


def forwards(apps, schema_editor):
    # All existing InstanceLink objects need to be in the state
    # 'Established', which is the default, so nothing needs to be done
    # for that.

    Instance = apps.get_model('main', 'Instance')
    for instance in Instance.objects.all():
        instance.node_state = 'ready' if not instance.errors else 'unavailable'
        instance.save(update_fields=['node_state'])


class Migration(migrations.Migration):
    dependencies = [
        ('main', '0169_jt_prompt_everything_on_launch'),
    ]

    operations = [
        migrations.AddField(
            model_name='instance',
            name='listener_port',
            field=models.PositiveIntegerField(
                blank=True,
                default=27199,
                help_text='Port that Receptor will listen for incoming connections on.',
                validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(65535)],
            ),
        ),
        migrations.AddField(
            model_name='instance',
            name='node_state',
            field=models.CharField(
                choices=[
                    ('provisioning', 'Provisioning'),
                    ('provision-fail', 'Provisioning Failure'),
                    ('installed', 'Installed'),
                    ('ready', 'Ready'),
                    ('unavailable', 'Unavailable'),
                    ('deprovisioning', 'De-provisioning'),
                    ('deprovision-fail', 'De-provisioning Failure'),
                ],
                default='ready',
                help_text='Indicates the current life cycle stage of this instance.',
                max_length=16,
            ),
        ),
        migrations.AddField(
            model_name='instancelink',
            name='link_state',
            field=models.CharField(
                choices=[('adding', 'Adding'), ('established', 'Established'), ('removing', 'Removing')],
                default='established',
                help_text='Indicates the current life cycle stage of this peer link.',
                max_length=16,
            ),
        ),
        migrations.AlterField(
            model_name='instance',
            name='node_type',
            field=models.CharField(
                choices=[
                    ('control', 'Control plane node'),
                    ('execution', 'Execution plane node'),
                    ('hybrid', 'Controller and execution'),
                    ('hop', 'Message-passing node, no execution capability'),
                ],
                default='hybrid',
                help_text='Role that this node plays in the mesh.',
                max_length=16,
            ),
        ),
        migrations.RunPython(forwards, reverse_code=migrations.RunPython.noop),
    ]
