# Generated by Django 4.2.3 on 2023-08-02 13:18

import awx.main.models.notifications
from django.db import migrations, models

from ._sqlite_helper import dbawaremigrations


class Migration(migrations.Migration):
    dependencies = [
        ('main', '0184_django_indexes'),
        ('conf', '0010_change_to_JSONField'),
    ]

    operations = [
        migrations.AlterField(
            model_name='instancegroup',
            name='policy_instance_list',
            field=models.JSONField(
                blank=True, default=list, help_text='List of exact-match Instances that will always be automatically assigned to this group'
            ),
        ),
        migrations.AlterField(
            model_name='jobtemplate',
            name='survey_spec',
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.AlterField(
            model_name='notificationtemplate',
            name='messages',
            field=models.JSONField(
                blank=True,
                default=awx.main.models.notifications.NotificationTemplate.default_messages,
                help_text='Optional custom messages for notification template.',
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name='notificationtemplate',
            name='notification_configuration',
            field=models.JSONField(default=dict),
        ),
        migrations.AlterField(
            model_name='project',
            name='inventory_files',
            field=models.JSONField(
                blank=True,
                default=list,
                editable=False,
                help_text='Suggested list of content that could be Ansible inventory in the project',
                verbose_name='Inventory Files',
            ),
        ),
        migrations.AlterField(
            model_name='project',
            name='playbook_files',
            field=models.JSONField(blank=True, default=list, editable=False, help_text='List of playbooks found in the project', verbose_name='Playbook Files'),
        ),
        migrations.AlterField(
            model_name='schedule',
            name='char_prompts',
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.AlterField(
            model_name='schedule',
            name='survey_passwords',
            field=models.JSONField(blank=True, default=dict, editable=False),
        ),
        migrations.AlterField(
            model_name='workflowjobtemplate',
            name='char_prompts',
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.AlterField(
            model_name='workflowjobtemplate',
            name='survey_spec',
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.AlterField(
            model_name='workflowjobtemplatenode',
            name='char_prompts',
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.AlterField(
            model_name='workflowjobtemplatenode',
            name='survey_passwords',
            field=models.JSONField(blank=True, default=dict, editable=False),
        ),
        # These are potentially a problem.  Move the existing fields
        # aside while pretending like they've been deleted, then add
        # in fresh empty fields.  Make the old fields nullable where
        # needed while we are at it, so that new rows don't hit
        # IntegrityError.  We'll do the data migration out-of-band
        # using a task.
        migrations.RunSQL(  # Already nullable
            "ALTER TABLE main_activitystream RENAME deleted_actor TO deleted_actor_old;",
            state_operations=[
                migrations.RemoveField(
                    model_name='activitystream',
                    name='deleted_actor',
                ),
            ],
        ),
        migrations.AddField(
            model_name='activitystream',
            name='deleted_actor',
            field=models.JSONField(null=True),
        ),
        dbawaremigrations.RunSQL(
            """
            ALTER TABLE main_activitystream RENAME setting TO setting_old;
            ALTER TABLE main_activitystream ALTER COLUMN setting_old DROP NOT NULL;
            """,
            sqlite_sql="ALTER TABLE main_activitystream RENAME setting TO setting_old",
            state_operations=[
                migrations.RemoveField(
                    model_name='activitystream',
                    name='setting',
                ),
            ],
        ),
        migrations.AddField(
            model_name='activitystream',
            name='setting',
            field=models.JSONField(blank=True, default=dict),
        ),
        dbawaremigrations.RunSQL(
            """
            ALTER TABLE main_job RENAME survey_passwords TO survey_passwords_old;
            ALTER TABLE main_job ALTER COLUMN survey_passwords_old DROP NOT NULL;
            """,
            sqlite_sql="ALTER TABLE main_job RENAME survey_passwords TO survey_passwords_old",
            state_operations=[
                migrations.RemoveField(
                    model_name='job',
                    name='survey_passwords',
                ),
            ],
        ),
        migrations.AddField(
            model_name='job',
            name='survey_passwords',
            field=models.JSONField(blank=True, default=dict, editable=False),
        ),
        dbawaremigrations.RunSQL(
            """
            ALTER TABLE main_joblaunchconfig RENAME char_prompts TO char_prompts_old;
            ALTER TABLE main_joblaunchconfig ALTER COLUMN char_prompts_old DROP NOT NULL;
            """,
            sqlite_sql="ALTER TABLE main_joblaunchconfig RENAME char_prompts TO char_prompts_old",
            state_operations=[
                migrations.RemoveField(
                    model_name='joblaunchconfig',
                    name='char_prompts',
                ),
            ],
        ),
        migrations.AddField(
            model_name='joblaunchconfig',
            name='char_prompts',
            field=models.JSONField(blank=True, default=dict),
        ),
        dbawaremigrations.RunSQL(
            """
            ALTER TABLE main_joblaunchconfig RENAME survey_passwords TO survey_passwords_old;
            ALTER TABLE main_joblaunchconfig ALTER COLUMN survey_passwords_old DROP NOT NULL;
            """,
            sqlite_sql="ALTER TABLE main_joblaunchconfig RENAME survey_passwords TO survey_passwords_old;",
            state_operations=[
                migrations.RemoveField(
                    model_name='joblaunchconfig',
                    name='survey_passwords',
                ),
            ],
        ),
        migrations.AddField(
            model_name='joblaunchconfig',
            name='survey_passwords',
            field=models.JSONField(blank=True, default=dict, editable=False),
        ),
        dbawaremigrations.RunSQL(
            """
            ALTER TABLE main_notification RENAME body TO body_old;
            ALTER TABLE main_notification ALTER COLUMN body_old DROP NOT NULL;
            """,
            sqlite_sql="ALTER TABLE main_notification RENAME body TO body_old",
            state_operations=[
                migrations.RemoveField(
                    model_name='notification',
                    name='body',
                ),
            ],
        ),
        migrations.AddField(
            model_name='notification',
            name='body',
            field=models.JSONField(blank=True, default=dict),
        ),
        dbawaremigrations.RunSQL(
            """
            ALTER TABLE main_unifiedjob RENAME job_env TO job_env_old;
            ALTER TABLE main_unifiedjob ALTER COLUMN job_env_old DROP NOT NULL;
            """,
            sqlite_sql="ALTER TABLE main_unifiedjob RENAME job_env TO job_env_old",
            state_operations=[
                migrations.RemoveField(
                    model_name='unifiedjob',
                    name='job_env',
                ),
            ],
        ),
        migrations.AddField(
            model_name='unifiedjob',
            name='job_env',
            field=models.JSONField(blank=True, default=dict, editable=False),
        ),
        dbawaremigrations.RunSQL(
            """
            ALTER TABLE main_workflowjob RENAME char_prompts TO char_prompts_old;
            ALTER TABLE main_workflowjob ALTER COLUMN char_prompts_old DROP NOT NULL;
            """,
            sqlite_sql="ALTER TABLE main_workflowjob RENAME char_prompts TO char_prompts_old",
            state_operations=[
                migrations.RemoveField(
                    model_name='workflowjob',
                    name='char_prompts',
                ),
            ],
        ),
        migrations.AddField(
            model_name='workflowjob',
            name='char_prompts',
            field=models.JSONField(blank=True, default=dict),
        ),
        dbawaremigrations.RunSQL(
            """
            ALTER TABLE main_workflowjob RENAME survey_passwords TO survey_passwords_old;
            ALTER TABLE main_workflowjob ALTER COLUMN survey_passwords_old DROP NOT NULL;
            """,
            sqlite_sql="ALTER TABLE main_workflowjob RENAME survey_passwords TO survey_passwords_old",
            state_operations=[
                migrations.RemoveField(
                    model_name='workflowjob',
                    name='survey_passwords',
                ),
            ],
        ),
        migrations.AddField(
            model_name='workflowjob',
            name='survey_passwords',
            field=models.JSONField(blank=True, default=dict, editable=False),
        ),
        dbawaremigrations.RunSQL(
            """
            ALTER TABLE main_workflowjobnode RENAME char_prompts TO char_prompts_old;
            ALTER TABLE main_workflowjobnode ALTER COLUMN char_prompts_old DROP NOT NULL;
            """,
            sqlite_sql="ALTER TABLE main_workflowjobnode RENAME char_prompts TO char_prompts_old",
            state_operations=[
                migrations.RemoveField(
                    model_name='workflowjobnode',
                    name='char_prompts',
                ),
            ],
        ),
        migrations.AddField(
            model_name='workflowjobnode',
            name='char_prompts',
            field=models.JSONField(blank=True, default=dict),
        ),
        dbawaremigrations.RunSQL(
            """
            ALTER TABLE main_workflowjobnode RENAME survey_passwords TO survey_passwords_old;
            ALTER TABLE main_workflowjobnode ALTER COLUMN survey_passwords_old DROP NOT NULL;
            """,
            sqlite_sql="ALTER TABLE main_workflowjobnode RENAME survey_passwords TO survey_passwords_old",
            state_operations=[
                migrations.RemoveField(
                    model_name='workflowjobnode',
                    name='survey_passwords',
                ),
            ],
        ),
        migrations.AddField(
            model_name='workflowjobnode',
            name='survey_passwords',
            field=models.JSONField(blank=True, default=dict, editable=False),
        ),
    ]
