# Generated by Django 4.2.6 on 2024-01-19 19:24

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


def create_receptor_addresses(apps, schema_editor):
    """
    If listener_port was defined on an instance, create a receptor address for it
    """
    Instance = apps.get_model('main', 'Instance')
    ReceptorAddress = apps.get_model('main', 'ReceptorAddress')
    for instance in Instance.objects.exclude(listener_port=None):
        ReceptorAddress.objects.create(
            instance=instance,
            address=instance.hostname,
            port=instance.listener_port,
            peers_from_control_nodes=instance.peers_from_control_nodes,
            protocol='tcp',
            is_internal=False,
            canonical=True,
        )


def link_to_receptor_addresses(apps, schema_editor):
    """
    Modify each InstanceLink to point to the newly created
    ReceptorAddresses, using the new target field
    """
    InstanceLink = apps.get_model('main', 'InstanceLink')
    for link in InstanceLink.objects.all():
        link.target = link.target_old.receptor_addresses.get()
        link.save()


class Migration(migrations.Migration):
    dependencies = [
        ('main', '0188_add_bitbucket_dc_webhook'),
    ]

    operations = [
        migrations.CreateModel(
            name='ReceptorAddress',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address', models.CharField(help_text='Routable address for this instance.', max_length=255)),
                (
                    'port',
                    models.IntegerField(
                        default=27199,
                        help_text='Port for the address.',
                        validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(65535)],
                    ),
                ),
                ('websocket_path', models.CharField(blank=True, default='', help_text='Websocket path.', max_length=255)),
                (
                    'protocol',
                    models.CharField(
                        choices=[('tcp', 'TCP'), ('ws', 'WS'), ('wss', 'WSS')],
                        default='tcp',
                        help_text="Protocol to use for the Receptor listener, 'tcp', 'wss', or 'ws'.",
                        max_length=10,
                    ),
                ),
                ('is_internal', models.BooleanField(default=False, help_text='If True, only routable within the Kubernetes cluster.')),
                ('canonical', models.BooleanField(default=False, help_text='If True, this address is the canonical address for the instance.')),
                (
                    'peers_from_control_nodes',
                    models.BooleanField(default=False, help_text='If True, control plane cluster nodes should automatically peer to it.'),
                ),
            ],
        ),
        migrations.RemoveConstraint(
            model_name='instancelink',
            name='source_and_target_can_not_be_equal',
        ),
        migrations.RenameField(
            model_name='instancelink',
            old_name='target',
            new_name='target_old',
        ),
        migrations.AlterUniqueTogether(
            name='instancelink',
            unique_together=set(),
        ),
        migrations.AddField(
            model_name='instance',
            name='managed',
            field=models.BooleanField(default=False, editable=False, help_text='If True, this instance is managed by the control plane.'),
        ),
        migrations.AlterField(
            model_name='instancelink',
            name='source',
            field=models.ForeignKey(help_text='The source instance of this peer link.', on_delete=django.db.models.deletion.CASCADE, to='main.instance'),
        ),
        migrations.AddField(
            model_name='receptoraddress',
            name='instance',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='receptor_addresses', to='main.instance'),
        ),
        migrations.AddField(
            model_name='activitystream',
            name='receptor_address',
            field=models.ManyToManyField(blank=True, to='main.receptoraddress'),
        ),
        migrations.AddConstraint(
            model_name='receptoraddress',
            constraint=models.UniqueConstraint(fields=('address',), name='unique_receptor_address', violation_error_message='Receptor address must be unique.'),
        ),
        migrations.AddField(
            model_name='instancelink',
            name='target',
            field=models.ForeignKey(
                help_text='The target receptor address of this peer link.', null=True, on_delete=django.db.models.deletion.CASCADE, to='main.receptoraddress'
            ),
        ),
        migrations.RunPython(create_receptor_addresses),
        migrations.RunPython(link_to_receptor_addresses),
        migrations.RemoveField(
            model_name='instance',
            name='peers_from_control_nodes',
        ),
        migrations.RemoveField(
            model_name='instance',
            name='listener_port',
        ),
        migrations.RemoveField(
            model_name='instancelink',
            name='target_old',
        ),
        migrations.AlterField(
            model_name='instance',
            name='peers',
            field=models.ManyToManyField(related_name='peers_from', through='main.InstanceLink', to='main.receptoraddress'),
        ),
        migrations.AlterField(
            model_name='instancelink',
            name='target',
            field=models.ForeignKey(
                help_text='The target receptor address of this peer link.', on_delete=django.db.models.deletion.CASCADE, to='main.receptoraddress'
            ),
        ),
        migrations.AddConstraint(
            model_name='instancelink',
            constraint=models.UniqueConstraint(
                fields=('source', 'target'), name='unique_source_target', violation_error_message='Field source and target must be unique together.'
            ),
        ),
    ]
