#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<Application>::TypeImpl()
{ }

TypeImpl<Application>::~TypeImpl()
{ }

String TypeImpl<Application>::GetName() const
{
	return "Application";
}

int TypeImpl<Application>::GetAttributes() const
{
	return 1;
}

Type::Ptr TypeImpl<Application>::GetBaseType() const
{
	return ConfigObject::TypeInstance;
}

int TypeImpl<Application>::GetFieldId(const String& name) const
{

	return ConfigObject::TypeInstance->GetFieldId(name);
}

Field TypeImpl<Application>::GetFieldInfo(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount();
	if (real_id < 0) { return ConfigObject::TypeInstance->GetFieldInfo(id); }
	throw std::runtime_error("Invalid field ID.");
}

int TypeImpl<Application>::GetFieldCount() const
{
	return 0 + ConfigObject::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<Application>::GetFactory() const
{
	return TypeHelper<Application, false>::GetFactory();
}

int TypeImpl<Application>::GetActivationPriority() const
{
	return 0;
}

void TypeImpl<Application>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	throw std::runtime_error("Invalid field ID.");
}

void ObjectImpl<Application>::Validate(int types, const ValidationUtils& utils)
{
	ConfigObject::Validate(types, utils);

}

ObjectImpl<Application>::ObjectImpl()
{
}

ObjectImpl<Application>::~ObjectImpl()
{ }

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
