#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<Configuration>::TypeImpl()
{ }

TypeImpl<Configuration>::~TypeImpl()
{ }

String TypeImpl<Configuration>::GetName() const
{
	return "Configuration";
}

int TypeImpl<Configuration>::GetAttributes() const
{
	return 1;
}

Type::Ptr TypeImpl<Configuration>::GetBaseType() const
{
	return Object::TypeInstance;
}

int TypeImpl<Configuration>::GetFieldId(const String& name) const
{
	int offset = 0;

	switch (static_cast<int>(Utility::SDBM(name, 4))) {
		case -1945669750:
			if (name == "DataDir")
				return offset + 17;

			break;
		case -1941539634:
			if (name == "ObjectsPath")
				return offset + 23;

			break;
		case -1837353076:
			if (name == "ZonesDir")
				return offset + 4;

			break;
		case -1103515515:
			if (name == "PidPath")
				return offset + 19;

			break;
		case -1086795720:
			if (name == "PkgDataDir")
				return offset + 12;

			break;
		case -1029096349:
			if (name == "PrefixDir")
				return offset + 0;

			break;
		case -1028440358:
			if (name == "ProgramData")
				return offset + 10;

			break;
		case -992574918:
			if (name == "EventEngine")
				return offset + 18;

			break;
		case -780133236:
			if (name == "VarsPath")
				return offset + 5;

			break;
		case 118606433:
			if (name == "LocalStateDir")
				return offset + 3;

			break;
		case 118868800:
			if (name == "LogDir")
				return offset + 21;

			break;
		case 130736904:
			if (name == "ApiBindHost")
				return offset + 11;
			if (name == "ApiBindPort")
				return offset + 14;

			break;
		case 164504544:
			if (name == "AttachDebugger")
				return offset + 29;

			break;
		case 218403262:
			if (name == "RLimitStack")
				return offset + 25;
			if (name == "RLimitProcesses")
				return offset + 26;
			if (name == "RLimitFiles")
				return offset + 27;

			break;
		case 557452918:
			if (name == "RunAsUser")
				return offset + 8;
			if (name == "RunAsGroup")
				return offset + 9;

			break;
		case 557452921:
			if (name == "RunDir")
				return offset + 2;

			break;
		case 899259199:
			if (name == "ModAttrPath")
				return offset + 22;

			break;
		case 1296798237:
			if (name == "SpoolDir")
				return offset + 7;

			break;
		case 1328925876:
			if (name == "StatePath")
				return offset + 6;

			break;
		case 1371414166:
			if (name == "SysconfDir")
				return offset + 1;

			break;
		case 1567595171:
			if (name == "CacheDir")
				return offset + 15;

			break;
		case 1683977825:
			if (name == "Concurrency")
				return offset + 28;

			break;
		case 1683977828:
			if (name == "ConfigDir")
				return offset + 16;

			break;
		case 2044601773:
			if (name == "TlsHandshakeTimeout")
				return offset + 24;

			break;
		case 2063550638:
			if (name == "IncludeConfDir")
				return offset + 13;

			break;
		case 2063944240:
			if (name == "InitRunDir")
				return offset + 20;

			break;
	}

	return -1;
}

Field TypeImpl<Configuration>::GetFieldInfo(int id) const
{
	switch (id) {
		case 0:
			return {0, "String", "PrefixDir", "PrefixDir", nullptr, 24642, 0};
		case 1:
			return {1, "String", "SysconfDir", "SysconfDir", nullptr, 24642, 0};
		case 2:
			return {2, "String", "RunDir", "RunDir", nullptr, 24642, 0};
		case 3:
			return {3, "String", "LocalStateDir", "LocalStateDir", nullptr, 24642, 0};
		case 4:
			return {4, "String", "ZonesDir", "ZonesDir", nullptr, 24642, 0};
		case 5:
			return {5, "String", "VarsPath", "VarsPath", nullptr, 24642, 0};
		case 6:
			return {6, "String", "StatePath", "StatePath", nullptr, 24642, 0};
		case 7:
			return {7, "String", "SpoolDir", "SpoolDir", nullptr, 24642, 0};
		case 8:
			return {8, "String", "RunAsUser", "RunAsUser", nullptr, 24642, 0};
		case 9:
			return {9, "String", "RunAsGroup", "RunAsGroup", nullptr, 24642, 0};
		case 10:
			return {10, "String", "ProgramData", "ProgramData", nullptr, 24642, 0};
		case 11:
			return {11, "String", "ApiBindHost", "ApiBindHost", nullptr, 24642, 0};
		case 12:
			return {12, "String", "PkgDataDir", "PkgDataDir", nullptr, 24642, 0};
		case 13:
			return {13, "String", "IncludeConfDir", "IncludeConfDir", nullptr, 24642, 0};
		case 14:
			return {14, "String", "ApiBindPort", "ApiBindPort", nullptr, 24642, 0};
		case 15:
			return {15, "String", "CacheDir", "CacheDir", nullptr, 24642, 0};
		case 16:
			return {16, "String", "ConfigDir", "ConfigDir", nullptr, 24642, 0};
		case 17:
			return {17, "String", "DataDir", "DataDir", nullptr, 24642, 0};
		case 18:
			return {18, "String", "EventEngine", "EventEngine", nullptr, 24642, 0};
		case 19:
			return {19, "String", "PidPath", "PidPath", nullptr, 24642, 0};
		case 20:
			return {20, "String", "InitRunDir", "InitRunDir", nullptr, 24642, 0};
		case 21:
			return {21, "String", "LogDir", "LogDir", nullptr, 24642, 0};
		case 22:
			return {22, "String", "ModAttrPath", "ModAttrPath", nullptr, 24642, 0};
		case 23:
			return {23, "String", "ObjectsPath", "ObjectsPath", nullptr, 24642, 0};
		case 24:
			return {24, "Number", "TlsHandshakeTimeout", "TlsHandshakeTimeout", nullptr, 24642, 0};
		case 25:
			return {25, "Number", "RLimitStack", "RLimitStack", nullptr, 24642, 0};
		case 26:
			return {26, "Number", "RLimitProcesses", "RLimitProcesses", nullptr, 24642, 0};
		case 27:
			return {27, "Number", "RLimitFiles", "RLimitFiles", nullptr, 24642, 0};
		case 28:
			return {28, "Number", "Concurrency", "Concurrency", nullptr, 24642, 0};
		case 29:
			return {29, "Boolean", "AttachDebugger", "AttachDebugger", nullptr, 24642, 0};
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

int TypeImpl<Configuration>::GetFieldCount() const
{
	return 30;
}

ObjectFactory TypeImpl<Configuration>::GetFactory() const
{
	return TypeHelper<Configuration, false>::GetFactory();
}

int TypeImpl<Configuration>::GetActivationPriority() const
{
	return 0;
}

void TypeImpl<Configuration>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	switch (fieldId) {
		case 0:
			ObjectImpl<Configuration>::OnPrefixDirChanged.connect(callback);
			break;
		case 1:
			ObjectImpl<Configuration>::OnSysconfDirChanged.connect(callback);
			break;
		case 2:
			ObjectImpl<Configuration>::OnRunDirChanged.connect(callback);
			break;
		case 3:
			ObjectImpl<Configuration>::OnLocalStateDirChanged.connect(callback);
			break;
		case 4:
			ObjectImpl<Configuration>::OnZonesDirChanged.connect(callback);
			break;
		case 5:
			ObjectImpl<Configuration>::OnVarsPathChanged.connect(callback);
			break;
		case 6:
			ObjectImpl<Configuration>::OnStatePathChanged.connect(callback);
			break;
		case 7:
			ObjectImpl<Configuration>::OnSpoolDirChanged.connect(callback);
			break;
		case 8:
			ObjectImpl<Configuration>::OnRunAsUserChanged.connect(callback);
			break;
		case 9:
			ObjectImpl<Configuration>::OnRunAsGroupChanged.connect(callback);
			break;
		case 10:
			ObjectImpl<Configuration>::OnProgramDataChanged.connect(callback);
			break;
		case 11:
			ObjectImpl<Configuration>::OnApiBindHostChanged.connect(callback);
			break;
		case 12:
			ObjectImpl<Configuration>::OnPkgDataDirChanged.connect(callback);
			break;
		case 13:
			ObjectImpl<Configuration>::OnIncludeConfDirChanged.connect(callback);
			break;
		case 14:
			ObjectImpl<Configuration>::OnApiBindPortChanged.connect(callback);
			break;
		case 15:
			ObjectImpl<Configuration>::OnCacheDirChanged.connect(callback);
			break;
		case 16:
			ObjectImpl<Configuration>::OnConfigDirChanged.connect(callback);
			break;
		case 17:
			ObjectImpl<Configuration>::OnDataDirChanged.connect(callback);
			break;
		case 18:
			ObjectImpl<Configuration>::OnEventEngineChanged.connect(callback);
			break;
		case 19:
			ObjectImpl<Configuration>::OnPidPathChanged.connect(callback);
			break;
		case 20:
			ObjectImpl<Configuration>::OnInitRunDirChanged.connect(callback);
			break;
		case 21:
			ObjectImpl<Configuration>::OnLogDirChanged.connect(callback);
			break;
		case 22:
			ObjectImpl<Configuration>::OnModAttrPathChanged.connect(callback);
			break;
		case 23:
			ObjectImpl<Configuration>::OnObjectsPathChanged.connect(callback);
			break;
		case 24:
			ObjectImpl<Configuration>::OnTlsHandshakeTimeoutChanged.connect(callback);
			break;
		case 25:
			ObjectImpl<Configuration>::OnRLimitStackChanged.connect(callback);
			break;
		case 26:
			ObjectImpl<Configuration>::OnRLimitProcessesChanged.connect(callback);
			break;
		case 27:
			ObjectImpl<Configuration>::OnRLimitFilesChanged.connect(callback);
			break;
		case 28:
			ObjectImpl<Configuration>::OnConcurrencyChanged.connect(callback);
			break;
		case 29:
			ObjectImpl<Configuration>::OnAttachDebuggerChanged.connect(callback);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<Configuration>::Validate(int types, const ValidationUtils& utils)
{
	if (2 & types)
		ValidatePrefixDir(Lazy<String>([this]() { return GetPrefixDir(); }), utils);
	if (2 & types)
		ValidateSysconfDir(Lazy<String>([this]() { return GetSysconfDir(); }), utils);
	if (2 & types)
		ValidateRunDir(Lazy<String>([this]() { return GetRunDir(); }), utils);
	if (2 & types)
		ValidateLocalStateDir(Lazy<String>([this]() { return GetLocalStateDir(); }), utils);
	if (2 & types)
		ValidateZonesDir(Lazy<String>([this]() { return GetZonesDir(); }), utils);
	if (2 & types)
		ValidateVarsPath(Lazy<String>([this]() { return GetVarsPath(); }), utils);
	if (2 & types)
		ValidateStatePath(Lazy<String>([this]() { return GetStatePath(); }), utils);
	if (2 & types)
		ValidateSpoolDir(Lazy<String>([this]() { return GetSpoolDir(); }), utils);
	if (2 & types)
		ValidateRunAsUser(Lazy<String>([this]() { return GetRunAsUser(); }), utils);
	if (2 & types)
		ValidateRunAsGroup(Lazy<String>([this]() { return GetRunAsGroup(); }), utils);
	if (2 & types)
		ValidateProgramData(Lazy<String>([this]() { return GetProgramData(); }), utils);
	if (2 & types)
		ValidateApiBindHost(Lazy<String>([this]() { return GetApiBindHost(); }), utils);
	if (2 & types)
		ValidatePkgDataDir(Lazy<String>([this]() { return GetPkgDataDir(); }), utils);
	if (2 & types)
		ValidateIncludeConfDir(Lazy<String>([this]() { return GetIncludeConfDir(); }), utils);
	if (2 & types)
		ValidateApiBindPort(Lazy<String>([this]() { return GetApiBindPort(); }), utils);
	if (2 & types)
		ValidateCacheDir(Lazy<String>([this]() { return GetCacheDir(); }), utils);
	if (2 & types)
		ValidateConfigDir(Lazy<String>([this]() { return GetConfigDir(); }), utils);
	if (2 & types)
		ValidateDataDir(Lazy<String>([this]() { return GetDataDir(); }), utils);
	if (2 & types)
		ValidateEventEngine(Lazy<String>([this]() { return GetEventEngine(); }), utils);
	if (2 & types)
		ValidatePidPath(Lazy<String>([this]() { return GetPidPath(); }), utils);
	if (2 & types)
		ValidateInitRunDir(Lazy<String>([this]() { return GetInitRunDir(); }), utils);
	if (2 & types)
		ValidateLogDir(Lazy<String>([this]() { return GetLogDir(); }), utils);
	if (2 & types)
		ValidateModAttrPath(Lazy<String>([this]() { return GetModAttrPath(); }), utils);
	if (2 & types)
		ValidateObjectsPath(Lazy<String>([this]() { return GetObjectsPath(); }), utils);
	if (2 & types)
		ValidateTlsHandshakeTimeout(Lazy<double>([this]() { return GetTlsHandshakeTimeout(); }), utils);
	if (2 & types)
		ValidateRLimitStack(Lazy<int>([this]() { return GetRLimitStack(); }), utils);
	if (2 & types)
		ValidateRLimitProcesses(Lazy<int>([this]() { return GetRLimitProcesses(); }), utils);
	if (2 & types)
		ValidateRLimitFiles(Lazy<int>([this]() { return GetRLimitFiles(); }), utils);
	if (2 & types)
		ValidateConcurrency(Lazy<int>([this]() { return GetConcurrency(); }), utils);
	if (2 & types)
		ValidateAttachDebugger(Lazy<bool>([this]() { return GetAttachDebugger(); }), utils);
}

void ObjectImpl<Configuration>::SimpleValidatePrefixDir(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateSysconfDir(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateRunDir(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateLocalStateDir(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateZonesDir(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateVarsPath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateStatePath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateSpoolDir(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateRunAsUser(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateRunAsGroup(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateProgramData(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateApiBindHost(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidatePkgDataDir(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateIncludeConfDir(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateApiBindPort(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateCacheDir(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateConfigDir(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateDataDir(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateEventEngine(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidatePidPath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateInitRunDir(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateLogDir(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateModAttrPath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateObjectsPath(const Lazy<String>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateTlsHandshakeTimeout(const Lazy<double>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateRLimitStack(const Lazy<int>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateRLimitProcesses(const Lazy<int>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateRLimitFiles(const Lazy<int>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateConcurrency(const Lazy<int>& value, const ValidationUtils& utils)
{
}

void ObjectImpl<Configuration>::SimpleValidateAttachDebugger(const Lazy<bool>& value, const ValidationUtils& utils)
{
}

ObjectImpl<Configuration>::ObjectImpl()
{
}

ObjectImpl<Configuration>::~ObjectImpl()
{ }

void ObjectImpl<Configuration>::SetField(int id, const Value& value, bool suppress_events, const Value& cookie)
{
	switch (id) {
		case 0:
			SetPrefixDir(value, suppress_events, cookie);
			break;
		case 1:
			SetSysconfDir(value, suppress_events, cookie);
			break;
		case 2:
			SetRunDir(value, suppress_events, cookie);
			break;
		case 3:
			SetLocalStateDir(value, suppress_events, cookie);
			break;
		case 4:
			SetZonesDir(value, suppress_events, cookie);
			break;
		case 5:
			SetVarsPath(value, suppress_events, cookie);
			break;
		case 6:
			SetStatePath(value, suppress_events, cookie);
			break;
		case 7:
			SetSpoolDir(value, suppress_events, cookie);
			break;
		case 8:
			SetRunAsUser(value, suppress_events, cookie);
			break;
		case 9:
			SetRunAsGroup(value, suppress_events, cookie);
			break;
		case 10:
			SetProgramData(value, suppress_events, cookie);
			break;
		case 11:
			SetApiBindHost(value, suppress_events, cookie);
			break;
		case 12:
			SetPkgDataDir(value, suppress_events, cookie);
			break;
		case 13:
			SetIncludeConfDir(value, suppress_events, cookie);
			break;
		case 14:
			SetApiBindPort(value, suppress_events, cookie);
			break;
		case 15:
			SetCacheDir(value, suppress_events, cookie);
			break;
		case 16:
			SetConfigDir(value, suppress_events, cookie);
			break;
		case 17:
			SetDataDir(value, suppress_events, cookie);
			break;
		case 18:
			SetEventEngine(value, suppress_events, cookie);
			break;
		case 19:
			SetPidPath(value, suppress_events, cookie);
			break;
		case 20:
			SetInitRunDir(value, suppress_events, cookie);
			break;
		case 21:
			SetLogDir(value, suppress_events, cookie);
			break;
		case 22:
			SetModAttrPath(value, suppress_events, cookie);
			break;
		case 23:
			SetObjectsPath(value, suppress_events, cookie);
			break;
		case 24:
			SetTlsHandshakeTimeout(value, suppress_events, cookie);
			break;
		case 25:
			SetRLimitStack(value, suppress_events, cookie);
			break;
		case 26:
			SetRLimitProcesses(value, suppress_events, cookie);
			break;
		case 27:
			SetRLimitFiles(value, suppress_events, cookie);
			break;
		case 28:
			SetConcurrency(value, suppress_events, cookie);
			break;
		case 29:
			SetAttachDebugger(value, suppress_events, cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Value ObjectImpl<Configuration>::GetField(int id) const
{
	switch (id) {
		case 0:
			return GetPrefixDir();
		case 1:
			return GetSysconfDir();
		case 2:
			return GetRunDir();
		case 3:
			return GetLocalStateDir();
		case 4:
			return GetZonesDir();
		case 5:
			return GetVarsPath();
		case 6:
			return GetStatePath();
		case 7:
			return GetSpoolDir();
		case 8:
			return GetRunAsUser();
		case 9:
			return GetRunAsGroup();
		case 10:
			return GetProgramData();
		case 11:
			return GetApiBindHost();
		case 12:
			return GetPkgDataDir();
		case 13:
			return GetIncludeConfDir();
		case 14:
			return GetApiBindPort();
		case 15:
			return GetCacheDir();
		case 16:
			return GetConfigDir();
		case 17:
			return GetDataDir();
		case 18:
			return GetEventEngine();
		case 19:
			return GetPidPath();
		case 20:
			return GetInitRunDir();
		case 21:
			return GetLogDir();
		case 22:
			return GetModAttrPath();
		case 23:
			return GetObjectsPath();
		case 24:
			return GetTlsHandshakeTimeout();
		case 25:
			return GetRLimitStack();
		case 26:
			return GetRLimitProcesses();
		case 27:
			return GetRLimitFiles();
		case 28:
			return GetConcurrency();
		case 29:
			return GetAttachDebugger();
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<Configuration>::ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils)
{
	switch (id) {
		case 0:
			ValidatePrefixDir(lvalue, utils);
			break;
		case 1:
			ValidateSysconfDir(lvalue, utils);
			break;
		case 2:
			ValidateRunDir(lvalue, utils);
			break;
		case 3:
			ValidateLocalStateDir(lvalue, utils);
			break;
		case 4:
			ValidateZonesDir(lvalue, utils);
			break;
		case 5:
			ValidateVarsPath(lvalue, utils);
			break;
		case 6:
			ValidateStatePath(lvalue, utils);
			break;
		case 7:
			ValidateSpoolDir(lvalue, utils);
			break;
		case 8:
			ValidateRunAsUser(lvalue, utils);
			break;
		case 9:
			ValidateRunAsGroup(lvalue, utils);
			break;
		case 10:
			ValidateProgramData(lvalue, utils);
			break;
		case 11:
			ValidateApiBindHost(lvalue, utils);
			break;
		case 12:
			ValidatePkgDataDir(lvalue, utils);
			break;
		case 13:
			ValidateIncludeConfDir(lvalue, utils);
			break;
		case 14:
			ValidateApiBindPort(lvalue, utils);
			break;
		case 15:
			ValidateCacheDir(lvalue, utils);
			break;
		case 16:
			ValidateConfigDir(lvalue, utils);
			break;
		case 17:
			ValidateDataDir(lvalue, utils);
			break;
		case 18:
			ValidateEventEngine(lvalue, utils);
			break;
		case 19:
			ValidatePidPath(lvalue, utils);
			break;
		case 20:
			ValidateInitRunDir(lvalue, utils);
			break;
		case 21:
			ValidateLogDir(lvalue, utils);
			break;
		case 22:
			ValidateModAttrPath(lvalue, utils);
			break;
		case 23:
			ValidateObjectsPath(lvalue, utils);
			break;
		case 24:
			ValidateTlsHandshakeTimeout(lvalue, utils);
			break;
		case 25:
			ValidateRLimitStack(lvalue, utils);
			break;
		case 26:
			ValidateRLimitProcesses(lvalue, utils);
			break;
		case 27:
			ValidateRLimitFiles(lvalue, utils);
			break;
		case 28:
			ValidateConcurrency(lvalue, utils);
			break;
		case 29:
			ValidateAttachDebugger(lvalue, utils);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<Configuration>::NotifyField(int id, const Value& cookie)
{
	switch (id) {
		case 0:
			NotifyPrefixDir(cookie);
			break;
		case 1:
			NotifySysconfDir(cookie);
			break;
		case 2:
			NotifyRunDir(cookie);
			break;
		case 3:
			NotifyLocalStateDir(cookie);
			break;
		case 4:
			NotifyZonesDir(cookie);
			break;
		case 5:
			NotifyVarsPath(cookie);
			break;
		case 6:
			NotifyStatePath(cookie);
			break;
		case 7:
			NotifySpoolDir(cookie);
			break;
		case 8:
			NotifyRunAsUser(cookie);
			break;
		case 9:
			NotifyRunAsGroup(cookie);
			break;
		case 10:
			NotifyProgramData(cookie);
			break;
		case 11:
			NotifyApiBindHost(cookie);
			break;
		case 12:
			NotifyPkgDataDir(cookie);
			break;
		case 13:
			NotifyIncludeConfDir(cookie);
			break;
		case 14:
			NotifyApiBindPort(cookie);
			break;
		case 15:
			NotifyCacheDir(cookie);
			break;
		case 16:
			NotifyConfigDir(cookie);
			break;
		case 17:
			NotifyDataDir(cookie);
			break;
		case 18:
			NotifyEventEngine(cookie);
			break;
		case 19:
			NotifyPidPath(cookie);
			break;
		case 20:
			NotifyInitRunDir(cookie);
			break;
		case 21:
			NotifyLogDir(cookie);
			break;
		case 22:
			NotifyModAttrPath(cookie);
			break;
		case 23:
			NotifyObjectsPath(cookie);
			break;
		case 24:
			NotifyTlsHandshakeTimeout(cookie);
			break;
		case 25:
			NotifyRLimitStack(cookie);
			break;
		case 26:
			NotifyRLimitProcesses(cookie);
			break;
		case 27:
			NotifyRLimitFiles(cookie);
			break;
		case 28:
			NotifyConcurrency(cookie);
			break;
		case 29:
			NotifyAttachDebugger(cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Object::Ptr ObjectImpl<Configuration>::NavigateField(int id) const
{
	throw std::runtime_error("Invalid field ID.");
}

void ObjectImpl<Configuration>::NotifyPrefixDir(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnPrefixDirChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifySysconfDir(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSysconfDirChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyRunDir(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnRunDirChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyLocalStateDir(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnLocalStateDirChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyZonesDir(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnZonesDirChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyVarsPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnVarsPathChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyStatePath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnStatePathChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifySpoolDir(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSpoolDirChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyRunAsUser(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnRunAsUserChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyRunAsGroup(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnRunAsGroupChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyProgramData(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnProgramDataChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyApiBindHost(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnApiBindHostChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyPkgDataDir(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnPkgDataDirChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyIncludeConfDir(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnIncludeConfDirChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyApiBindPort(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnApiBindPortChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyCacheDir(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnCacheDirChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyConfigDir(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnConfigDirChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyDataDir(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnDataDirChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyEventEngine(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnEventEngineChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyPidPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnPidPathChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyInitRunDir(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnInitRunDirChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyLogDir(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnLogDirChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyModAttrPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnModAttrPathChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyObjectsPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnObjectsPathChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyTlsHandshakeTimeout(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnTlsHandshakeTimeoutChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyRLimitStack(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnRLimitStackChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyRLimitProcesses(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnRLimitProcessesChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyRLimitFiles(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnRLimitFilesChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyConcurrency(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnConcurrencyChanged(static_cast<Configuration *>(this), cookie);
}

void ObjectImpl<Configuration>::NotifyAttachDebugger(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnAttachDebuggerChanged(static_cast<Configuration *>(this), cookie);
}

String ObjectImpl<Configuration>::GetDefaultPrefixDir() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultSysconfDir() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultRunDir() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultLocalStateDir() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultZonesDir() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultVarsPath() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultStatePath() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultSpoolDir() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultRunAsUser() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultRunAsGroup() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultProgramData() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultApiBindHost() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultPkgDataDir() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultIncludeConfDir() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultApiBindPort() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultCacheDir() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultConfigDir() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultDataDir() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultEventEngine() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultPidPath() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultInitRunDir() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultLogDir() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultModAttrPath() const
{
	return String();
}

String ObjectImpl<Configuration>::GetDefaultObjectsPath() const
{
	return String();
}

double ObjectImpl<Configuration>::GetDefaultTlsHandshakeTimeout() const
{
	return double();
}

int ObjectImpl<Configuration>::GetDefaultRLimitStack() const
{
	return int();
}

int ObjectImpl<Configuration>::GetDefaultRLimitProcesses() const
{
	return int();
}

int ObjectImpl<Configuration>::GetDefaultRLimitFiles() const
{
	return int();
}

int ObjectImpl<Configuration>::GetDefaultConcurrency() const
{
	return int();
}

bool ObjectImpl<Configuration>::GetDefaultAttachDebugger() const
{
	return bool();
}


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnPrefixDirChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnSysconfDirChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnRunDirChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnLocalStateDirChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnZonesDirChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnVarsPathChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnStatePathChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnSpoolDirChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnRunAsUserChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnRunAsGroupChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnProgramDataChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnApiBindHostChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnPkgDataDirChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnIncludeConfDirChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnApiBindPortChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnCacheDirChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnConfigDirChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnDataDirChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnEventEngineChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnPidPathChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnInitRunDirChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnLogDirChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnModAttrPathChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnObjectsPathChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnTlsHandshakeTimeoutChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnRLimitStackChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnRLimitProcessesChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnRLimitFilesChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnConcurrencyChanged;


boost::signals2::signal<void (const intrusive_ptr<Configuration>&, const Value&)> ObjectImpl<Configuration>::OnAttachDebuggerChanged;

void ObjectImpl<Configuration>::ValidateApiBindHost(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateApiBindHost(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateApiBindPort(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateApiBindPort(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateAttachDebugger(const Lazy<bool>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateAttachDebugger(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateCacheDir(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateCacheDir(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateConcurrency(const Lazy<int>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateConcurrency(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateConfigDir(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateConfigDir(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateDataDir(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateDataDir(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateEventEngine(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateEventEngine(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateIncludeConfDir(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateIncludeConfDir(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateInitRunDir(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateInitRunDir(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateLocalStateDir(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateLocalStateDir(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateLogDir(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateLogDir(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateModAttrPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateModAttrPath(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateObjectsPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateObjectsPath(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidatePidPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidatePidPath(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidatePkgDataDir(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidatePkgDataDir(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidatePrefixDir(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidatePrefixDir(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateProgramData(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateProgramData(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateRLimitFiles(const Lazy<int>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateRLimitFiles(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateRLimitProcesses(const Lazy<int>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateRLimitProcesses(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateRLimitStack(const Lazy<int>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateRLimitStack(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateRunAsGroup(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateRunAsGroup(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateRunAsUser(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateRunAsUser(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateRunDir(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateRunDir(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateSpoolDir(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSpoolDir(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateStatePath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateStatePath(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateSysconfDir(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSysconfDir(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateTlsHandshakeTimeout(const Lazy<double>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateTlsHandshakeTimeout(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateVarsPath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateVarsPath(lvalue, utils);
}

void ObjectImpl<Configuration>::ValidateZonesDir(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateZonesDir(lvalue, utils);
}

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
