#ifndef DATETIME_TI
#define DATETIME_TI

#include "base/object.hpp"
#include "base/type.hpp"
#include "base/value.hpp"
#include "base/array.hpp"
#include "base/atomic.hpp"
#include "base/dictionary.hpp"
#include <boost/signals2.hpp>

namespace icinga
{

class DateTime;

template<>
class TypeImpl<DateTime> : public Type
{
public:
	DECLARE_PTR_TYPEDEFS(TypeImpl<DateTime>);

	TypeImpl();
	~TypeImpl() override;

	String GetName() const override;
	int GetAttributes() const override;
	Type::Ptr GetBaseType() const override;
	int GetFieldId(const String& name) const override;
	Field GetFieldInfo(int id) const override;
	int GetFieldCount() const override;
	ObjectFactory GetFactory() const override;
	int GetActivationPriority() const override;
public:
	void RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback) override;
};


template<>
class ObjectImpl<DateTime> : public Object
{
public:
	DECLARE_PTR_TYPEDEFS(ObjectImpl<DateTime>);

	void Validate(int types, const ValidationUtils& utils) override;
	void SimpleValidateValue(const Lazy<Timestamp>& value, const ValidationUtils& utils);
public:
	ObjectImpl<DateTime>();
public:
	~ObjectImpl<DateTime>() override;
public:
	void SetField(int id, const Value& value, bool suppress_events = false, const Value& cookie = Empty) override;
public:
	Value GetField(int id) const override;
public:
	void ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils) override;
public:
	void NotifyField(int id, const Value& cookie = Empty) override;
public:
	Object::Ptr NavigateField(int id) const override;
public:
	virtual Timestamp GetValue() const = 0;
public:
	void SetValue(const Timestamp& value, bool suppress_events = false, const Value& cookie = Empty);
protected:
public:
	virtual void NotifyValue(const Value& cookie = Empty);
private:
	inline Timestamp GetDefaultValue() const;
protected:
	virtual void ValidateValue(const Lazy<Timestamp>& lvalue, const ValidationUtils& utils);
private:
public:
	static boost::signals2::signal<void (const intrusive_ptr<DateTime>&, const Value&)> OnValueChanged;
};

}
#endif /* DATETIME_TI */
