#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<FileLogger>::TypeImpl()
{ }

TypeImpl<FileLogger>::~TypeImpl()
{ }

String TypeImpl<FileLogger>::GetName() const
{
	return "FileLogger";
}

int TypeImpl<FileLogger>::GetAttributes() const
{
	return 0;
}

Type::Ptr TypeImpl<FileLogger>::GetBaseType() const
{
	return StreamLogger::TypeInstance;
}

int TypeImpl<FileLogger>::GetFieldId(const String& name) const
{
	int offset = StreamLogger::TypeInstance->GetFieldCount();

	switch (static_cast<int>(Utility::SDBM(name, 1))) {
		case 112:
			if (name == "path")
				return offset + 0;

			break;
	}

	return StreamLogger::TypeInstance->GetFieldId(name);
}

Field TypeImpl<FileLogger>::GetFieldInfo(int id) const
{
	int real_id = id - StreamLogger::TypeInstance->GetFieldCount();
	if (real_id < 0) { return StreamLogger::TypeInstance->GetFieldInfo(id); }
	switch (real_id) {
		case 0:
			return {0, "String", "path", "path", nullptr, 258, 0};
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

int TypeImpl<FileLogger>::GetFieldCount() const
{
	return 1 + StreamLogger::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<FileLogger>::GetFactory() const
{
	return TypeHelper<FileLogger, false>::GetFactory();
}

int TypeImpl<FileLogger>::GetActivationPriority() const
{
	return -100;
}

void TypeImpl<FileLogger>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - StreamLogger::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { StreamLogger::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	switch (real_id) {
		case 0:
			ObjectImpl<FileLogger>::OnPathChanged.connect(callback);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<FileLogger>::Validate(int types, const ValidationUtils& utils)
{
	StreamLogger::Validate(types, utils);

	if (2 & types)
		ValidatePath(Lazy<String>([this]() { return GetPath(); }), utils);
}

void ObjectImpl<FileLogger>::SimpleValidatePath(const Lazy<String>& value, const ValidationUtils& utils)
{
	if (value().IsEmpty())
		BOOST_THROW_EXCEPTION(ValidationError(dynamic_cast<ConfigObject *>(this), { "path" }, "Attribute must not be empty."));

}

ObjectImpl<FileLogger>::ObjectImpl()
{
	SetPath(GetDefaultPath(), true);
}

ObjectImpl<FileLogger>::~ObjectImpl()
{ }

void ObjectImpl<FileLogger>::SetField(int id, const Value& value, bool suppress_events, const Value& cookie)
{
	int real_id = id - StreamLogger::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { StreamLogger::SetField(id, value, suppress_events, cookie); return; }
	switch (real_id) {
		case 0:
			SetPath(value, suppress_events, cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Value ObjectImpl<FileLogger>::GetField(int id) const
{
	int real_id = id - StreamLogger::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return StreamLogger::GetField(id); }
	switch (real_id) {
		case 0:
			return GetPath();
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<FileLogger>::ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils)
{
	int real_id = id - StreamLogger::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { StreamLogger::ValidateField(id, lvalue, utils); return; }
	switch (real_id) {
		case 0:
			ValidatePath(lvalue, utils);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<FileLogger>::NotifyField(int id, const Value& cookie)
{
	int real_id = id - StreamLogger::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { StreamLogger::NotifyField(id, cookie); return; }
	switch (real_id) {
		case 0:
			NotifyPath(cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Object::Ptr ObjectImpl<FileLogger>::NavigateField(int id) const
{
	int real_id = id - StreamLogger::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return StreamLogger::NavigateField(id); }
	throw std::runtime_error("Invalid field ID.");
}

String ObjectImpl<FileLogger>::GetPath() const
{
	return m_Path.load();
}

void ObjectImpl<FileLogger>::SetPath(const String& value, bool suppress_events, const Value& cookie)
{
	m_Path.store(value);
	if (!suppress_events) {
		NotifyPath(cookie);
	}

}

void ObjectImpl<FileLogger>::NotifyPath(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnPathChanged(static_cast<FileLogger *>(this), cookie);
}

String ObjectImpl<FileLogger>::GetDefaultPath() const
{
	return String();
}


boost::signals2::signal<void (const intrusive_ptr<FileLogger>&, const Value&)> ObjectImpl<FileLogger>::OnPathChanged;

void ObjectImpl<FileLogger>::ValidatePath(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidatePath(lvalue, utils);
}

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
