#ifndef FILELOGGER_TI
#define FILELOGGER_TI

#include "base/object.hpp"
#include "base/type.hpp"
#include "base/value.hpp"
#include "base/array.hpp"
#include "base/atomic.hpp"
#include "base/dictionary.hpp"
#include <boost/signals2.hpp>

#include "base/streamlogger.hpp"

namespace icinga
{

class FileLogger;

template<>
class TypeImpl<FileLogger> : public TypeImpl<StreamLogger>
{
public:
	DECLARE_PTR_TYPEDEFS(TypeImpl<FileLogger>);

	TypeImpl();
	~TypeImpl() override;

	String GetName() const override;
	int GetAttributes() const override;
	Type::Ptr GetBaseType() const override;
	int GetFieldId(const String& name) const override;
	Field GetFieldInfo(int id) const override;
	int GetFieldCount() const override;
	ObjectFactory GetFactory() const override;
	int GetActivationPriority() const override;
public:
	void RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback) override;
};


template<>
class ObjectImpl<FileLogger> : public StreamLogger
{
public:
	DECLARE_PTR_TYPEDEFS(ObjectImpl<FileLogger>);

	void Validate(int types, const ValidationUtils& utils) override;
	void SimpleValidatePath(const Lazy<String>& value, const ValidationUtils& utils);
public:
	ObjectImpl<FileLogger>();
public:
	~ObjectImpl<FileLogger>() override;
public:
	void SetField(int id, const Value& value, bool suppress_events = false, const Value& cookie = Empty) override;
public:
	Value GetField(int id) const override;
public:
	void ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils) override;
public:
	void NotifyField(int id, const Value& cookie = Empty) override;
public:
	Object::Ptr NavigateField(int id) const override;
public:
	String GetPath() const;
public:
	void SetPath(const String& value, bool suppress_events = false, const Value& cookie = Empty);
protected:
public:
	virtual void NotifyPath(const Value& cookie = Empty);
private:
	inline String GetDefaultPath() const;
protected:
	virtual void ValidatePath(const Lazy<String>& lvalue, const ValidationUtils& utils);
private:
	AtomicOrLocked<String> m_Path;
public:
	static boost::signals2::signal<void (const intrusive_ptr<FileLogger>&, const Value&)> OnPathChanged;
};

}
#endif /* FILELOGGER_TI */
