#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<Logger>::TypeImpl()
{ }

TypeImpl<Logger>::~TypeImpl()
{ }

String TypeImpl<Logger>::GetName() const
{
	return "Logger";
}

int TypeImpl<Logger>::GetAttributes() const
{
	return 1;
}

Type::Ptr TypeImpl<Logger>::GetBaseType() const
{
	return ConfigObject::TypeInstance;
}

int TypeImpl<Logger>::GetFieldId(const String& name) const
{
	int offset = ConfigObject::TypeInstance->GetFieldCount();

	switch (static_cast<int>(Utility::SDBM(name, 1))) {
		case 115:
			if (name == "severity")
				return offset + 0;

			break;
	}

	return ConfigObject::TypeInstance->GetFieldId(name);
}

Field TypeImpl<Logger>::GetFieldInfo(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount();
	if (real_id < 0) { return ConfigObject::TypeInstance->GetFieldInfo(id); }
	switch (real_id) {
		case 0:
			return {0, "String", "severity", "severity", nullptr, 16386, 0};
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

int TypeImpl<Logger>::GetFieldCount() const
{
	return 1 + ConfigObject::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<Logger>::GetFactory() const
{
	return TypeHelper<Logger, false>::GetFactory();
}

int TypeImpl<Logger>::GetActivationPriority() const
{
	return 0;
}

void TypeImpl<Logger>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	switch (real_id) {
		case 0:
			ObjectImpl<Logger>::OnSeverityChanged.connect(callback);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<Logger>::Validate(int types, const ValidationUtils& utils)
{
	ConfigObject::Validate(types, utils);

	if (2 & types)
		ValidateSeverity(Lazy<String>([this]() { return GetSeverity(); }), utils);
}

void ObjectImpl<Logger>::SimpleValidateSeverity(const Lazy<String>& value, const ValidationUtils& utils)
{
}

ObjectImpl<Logger>::ObjectImpl()
{
	SetSeverity(GetDefaultSeverity(), true);
}

ObjectImpl<Logger>::~ObjectImpl()
{ }

void ObjectImpl<Logger>::SetField(int id, const Value& value, bool suppress_events, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::SetField(id, value, suppress_events, cookie); return; }
	switch (real_id) {
		case 0:
			SetSeverity(value, suppress_events, cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Value ObjectImpl<Logger>::GetField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::GetField(id); }
	switch (real_id) {
		case 0:
			return GetSeverity();
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<Logger>::ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::ValidateField(id, lvalue, utils); return; }
	switch (real_id) {
		case 0:
			ValidateSeverity(lvalue, utils);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<Logger>::NotifyField(int id, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::NotifyField(id, cookie); return; }
	switch (real_id) {
		case 0:
			NotifySeverity(cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Object::Ptr ObjectImpl<Logger>::NavigateField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::NavigateField(id); }
	throw std::runtime_error("Invalid field ID.");
}

String ObjectImpl<Logger>::GetSeverity() const
{
	return m_Severity.load();
}

void ObjectImpl<Logger>::SetSeverity(const String& value, bool suppress_events, const Value& cookie)
{
	m_Severity.store(value);
	if (!suppress_events) {
		NotifySeverity(cookie);
	}

}

void ObjectImpl<Logger>::NotifySeverity(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnSeverityChanged(static_cast<Logger *>(this), cookie);
}

String ObjectImpl<Logger>::GetDefaultSeverity() const
{
	 return "information"; 
}


boost::signals2::signal<void (const intrusive_ptr<Logger>&, const Value&)> ObjectImpl<Logger>::OnSeverityChanged;

void ObjectImpl<Logger>::ValidateSeverity(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateSeverity(lvalue, utils);
}

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
