#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<StreamLogger>::TypeImpl()
{ }

TypeImpl<StreamLogger>::~TypeImpl()
{ }

String TypeImpl<StreamLogger>::GetName() const
{
	return "StreamLogger";
}

int TypeImpl<StreamLogger>::GetAttributes() const
{
	return 1;
}

Type::Ptr TypeImpl<StreamLogger>::GetBaseType() const
{
	return Logger::TypeInstance;
}

int TypeImpl<StreamLogger>::GetFieldId(const String& name) const
{

	return Logger::TypeInstance->GetFieldId(name);
}

Field TypeImpl<StreamLogger>::GetFieldInfo(int id) const
{
	int real_id = id - Logger::TypeInstance->GetFieldCount();
	if (real_id < 0) { return Logger::TypeInstance->GetFieldInfo(id); }
	throw std::runtime_error("Invalid field ID.");
}

int TypeImpl<StreamLogger>::GetFieldCount() const
{
	return 0 + Logger::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<StreamLogger>::GetFactory() const
{
	return TypeHelper<StreamLogger, false>::GetFactory();
}

int TypeImpl<StreamLogger>::GetActivationPriority() const
{
	return 0;
}

void TypeImpl<StreamLogger>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - Logger::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { Logger::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	throw std::runtime_error("Invalid field ID.");
}

void ObjectImpl<StreamLogger>::Validate(int types, const ValidationUtils& utils)
{
	Logger::Validate(types, utils);

}

ObjectImpl<StreamLogger>::ObjectImpl()
{
}

ObjectImpl<StreamLogger>::~ObjectImpl()
{ }

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
