#ifndef STREAMLOGGER_TI
#define STREAMLOGGER_TI

#include "base/object.hpp"
#include "base/type.hpp"
#include "base/value.hpp"
#include "base/array.hpp"
#include "base/atomic.hpp"
#include "base/dictionary.hpp"
#include <boost/signals2.hpp>

#include "base/logger.hpp"

namespace icinga
{

class StreamLogger;

template<>
struct TypeHelper<StreamLogger, false>
{
	static ObjectFactory GetFactory()
	{
		return nullptr;
	}
};

template<>
class TypeImpl<StreamLogger> : public TypeImpl<Logger>
{
public:
	DECLARE_PTR_TYPEDEFS(TypeImpl<StreamLogger>);

	TypeImpl();
	~TypeImpl() override;

	String GetName() const override;
	int GetAttributes() const override;
	Type::Ptr GetBaseType() const override;
	int GetFieldId(const String& name) const override;
	Field GetFieldInfo(int id) const override;
	int GetFieldCount() const override;
	ObjectFactory GetFactory() const override;
	int GetActivationPriority() const override;
public:
	void RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback) override;
};


template<>
class ObjectImpl<StreamLogger> : public Logger
{
public:
	DECLARE_PTR_TYPEDEFS(ObjectImpl<StreamLogger>);

	void Validate(int types, const ValidationUtils& utils) override;
public:
	ObjectImpl<StreamLogger>();
public:
	~ObjectImpl<StreamLogger>() override;
};

}
#endif /* STREAMLOGGER_TI */
