#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<SyslogLogger>::TypeImpl()
{ }

TypeImpl<SyslogLogger>::~TypeImpl()
{ }

String TypeImpl<SyslogLogger>::GetName() const
{
	return "SyslogLogger";
}

int TypeImpl<SyslogLogger>::GetAttributes() const
{
	return 0;
}

Type::Ptr TypeImpl<SyslogLogger>::GetBaseType() const
{
	return Logger::TypeInstance;
}

int TypeImpl<SyslogLogger>::GetFieldId(const String& name) const
{
	int offset = Logger::TypeInstance->GetFieldCount();

	switch (static_cast<int>(Utility::SDBM(name, 1))) {
		case 102:
			if (name == "facility")
				return offset + 0;

			break;
	}

	return Logger::TypeInstance->GetFieldId(name);
}

Field TypeImpl<SyslogLogger>::GetFieldInfo(int id) const
{
	int real_id = id - Logger::TypeInstance->GetFieldCount();
	if (real_id < 0) { return Logger::TypeInstance->GetFieldInfo(id); }
	switch (real_id) {
		case 0:
			return {0, "String", "facility", "facility", nullptr, 2, 0};
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

int TypeImpl<SyslogLogger>::GetFieldCount() const
{
	return 1 + Logger::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<SyslogLogger>::GetFactory() const
{
	return TypeHelper<SyslogLogger, false>::GetFactory();
}

int TypeImpl<SyslogLogger>::GetActivationPriority() const
{
	return -100;
}

void TypeImpl<SyslogLogger>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - Logger::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { Logger::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	switch (real_id) {
		case 0:
			ObjectImpl<SyslogLogger>::OnFacilityChanged.connect(callback);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<SyslogLogger>::Validate(int types, const ValidationUtils& utils)
{
	Logger::Validate(types, utils);

	if (2 & types)
		ValidateFacility(Lazy<String>([this]() { return GetFacility(); }), utils);
}

void ObjectImpl<SyslogLogger>::SimpleValidateFacility(const Lazy<String>& value, const ValidationUtils& utils)
{
}

ObjectImpl<SyslogLogger>::ObjectImpl()
{
	SetFacility(GetDefaultFacility(), true);
}

ObjectImpl<SyslogLogger>::~ObjectImpl()
{ }

void ObjectImpl<SyslogLogger>::SetField(int id, const Value& value, bool suppress_events, const Value& cookie)
{
	int real_id = id - Logger::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { Logger::SetField(id, value, suppress_events, cookie); return; }
	switch (real_id) {
		case 0:
			SetFacility(value, suppress_events, cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Value ObjectImpl<SyslogLogger>::GetField(int id) const
{
	int real_id = id - Logger::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return Logger::GetField(id); }
	switch (real_id) {
		case 0:
			return GetFacility();
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<SyslogLogger>::ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils)
{
	int real_id = id - Logger::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { Logger::ValidateField(id, lvalue, utils); return; }
	switch (real_id) {
		case 0:
			ValidateFacility(lvalue, utils);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<SyslogLogger>::NotifyField(int id, const Value& cookie)
{
	int real_id = id - Logger::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { Logger::NotifyField(id, cookie); return; }
	switch (real_id) {
		case 0:
			NotifyFacility(cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Object::Ptr ObjectImpl<SyslogLogger>::NavigateField(int id) const
{
	int real_id = id - Logger::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return Logger::NavigateField(id); }
	throw std::runtime_error("Invalid field ID.");
}

String ObjectImpl<SyslogLogger>::GetFacility() const
{
	return m_Facility.load();
}

void ObjectImpl<SyslogLogger>::SetFacility(const String& value, bool suppress_events, const Value& cookie)
{
	m_Facility.store(value);
	if (!suppress_events) {
		NotifyFacility(cookie);
	}

}

void ObjectImpl<SyslogLogger>::NotifyFacility(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnFacilityChanged(static_cast<SyslogLogger *>(this), cookie);
}

String ObjectImpl<SyslogLogger>::GetDefaultFacility() const
{
	 return "LOG_USER"; 
}


boost::signals2::signal<void (const intrusive_ptr<SyslogLogger>&, const Value&)> ObjectImpl<SyslogLogger>::OnFacilityChanged;

void ObjectImpl<SyslogLogger>::ValidateFacility(const Lazy<String>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateFacility(lvalue, utils);
}

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
