#ifndef SYSLOGLOGGER_TI
#define SYSLOGLOGGER_TI

#include "base/object.hpp"
#include "base/type.hpp"
#include "base/value.hpp"
#include "base/array.hpp"
#include "base/atomic.hpp"
#include "base/dictionary.hpp"
#include <boost/signals2.hpp>

#include "base/logger.hpp"

namespace icinga
{

class SyslogLogger;

template<>
class TypeImpl<SyslogLogger> : public TypeImpl<Logger>
{
public:
	DECLARE_PTR_TYPEDEFS(TypeImpl<SyslogLogger>);

	TypeImpl();
	~TypeImpl() override;

	String GetName() const override;
	int GetAttributes() const override;
	Type::Ptr GetBaseType() const override;
	int GetFieldId(const String& name) const override;
	Field GetFieldInfo(int id) const override;
	int GetFieldCount() const override;
	ObjectFactory GetFactory() const override;
	int GetActivationPriority() const override;
public:
	void RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback) override;
};


template<>
class ObjectImpl<SyslogLogger> : public Logger
{
public:
	DECLARE_PTR_TYPEDEFS(ObjectImpl<SyslogLogger>);

	void Validate(int types, const ValidationUtils& utils) override;
	void SimpleValidateFacility(const Lazy<String>& value, const ValidationUtils& utils);
public:
	ObjectImpl<SyslogLogger>();
public:
	~ObjectImpl<SyslogLogger>() override;
public:
	void SetField(int id, const Value& value, bool suppress_events = false, const Value& cookie = Empty) override;
public:
	Value GetField(int id) const override;
public:
	void ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils) override;
public:
	void NotifyField(int id, const Value& cookie = Empty) override;
public:
	Object::Ptr NavigateField(int id) const override;
public:
	String GetFacility() const;
public:
	void SetFacility(const String& value, bool suppress_events = false, const Value& cookie = Empty);
protected:
public:
	virtual void NotifyFacility(const Value& cookie = Empty);
private:
	inline String GetDefaultFacility() const;
protected:
	virtual void ValidateFacility(const Lazy<String>& lvalue, const ValidationUtils& utils);
private:
	AtomicOrLocked<String> m_Facility;
public:
	static boost::signals2::signal<void (const intrusive_ptr<SyslogLogger>&, const Value&)> OnFacilityChanged;
};

}
#endif /* SYSLOGLOGGER_TI */
