#include "base/exception.hpp"
#include "base/objectlock.hpp"
#include "base/utility.hpp"
#include "base/convert.hpp"
#include "base/debug.hpp"
#include "base/dependencygraph.hpp"
#include "base/logger.hpp"
#include "base/function.hpp"
#include "base/configobject.hpp"
#include "base/configtype.hpp"
#ifdef _MSC_VER
#pragma warning( push )
#pragma warning( disable : 4244 )
#pragma warning( disable : 4800 )
#endif /* _MSC_VER */

namespace icinga
{

TypeImpl<CheckerComponent>::TypeImpl()
{ }

TypeImpl<CheckerComponent>::~TypeImpl()
{ }

String TypeImpl<CheckerComponent>::GetName() const
{
	return "CheckerComponent";
}

int TypeImpl<CheckerComponent>::GetAttributes() const
{
	return 0;
}

Type::Ptr TypeImpl<CheckerComponent>::GetBaseType() const
{
	return ConfigObject::TypeInstance;
}

int TypeImpl<CheckerComponent>::GetFieldId(const String& name) const
{
	int offset = ConfigObject::TypeInstance->GetFieldCount();

	switch (static_cast<int>(Utility::SDBM(name, 1))) {
		case 99:
			if (name == "concurrent_checks")
				return offset + 0;

			break;
	}

	return ConfigObject::TypeInstance->GetFieldId(name);
}

Field TypeImpl<CheckerComponent>::GetFieldInfo(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount();
	if (real_id < 0) { return ConfigObject::TypeInstance->GetFieldInfo(id); }
	switch (real_id) {
		case 0:
			return {0, "Number", "concurrent_checks", "concurrent_checks", nullptr, 4098, 0};
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

int TypeImpl<CheckerComponent>::GetFieldCount() const
{
	return 1 + ConfigObject::TypeInstance->GetFieldCount();
}

ObjectFactory TypeImpl<CheckerComponent>::GetFactory() const
{
	return TypeHelper<CheckerComponent, false>::GetFactory();
}

int TypeImpl<CheckerComponent>::GetActivationPriority() const
{
	return 300;
}

void TypeImpl<CheckerComponent>::RegisterAttributeHandler(int fieldId, const Type::AttributeHandler& callback)
{
	int real_id = fieldId - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::TypeInstance->RegisterAttributeHandler(fieldId, callback); return; }
	switch (real_id) {
		case 0:
			ObjectImpl<CheckerComponent>::OnConcurrentChecksChanged.connect(callback);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<CheckerComponent>::Validate(int types, const ValidationUtils& utils)
{
	ConfigObject::Validate(types, utils);

	if (2 & types)
		ValidateConcurrentChecks(Lazy<int>([this]() { return GetConcurrentChecks(); }), utils);
}

void ObjectImpl<CheckerComponent>::SimpleValidateConcurrentChecks(const Lazy<int>& value, const ValidationUtils& utils)
{
	if (value() != GetDefaultConcurrentChecks())
		Log(LogWarning, "CheckerComponent") << "Attribute 'concurrent_checks' for object '" << dynamic_cast<ConfigObject *>(this)->GetName() << "' of type '" << dynamic_cast<ConfigObject *>(this)->GetReflectionType()->GetName() << "' is deprecated and should not be used.";
}

ObjectImpl<CheckerComponent>::ObjectImpl()
{
	SetConcurrentChecks(GetDefaultConcurrentChecks(), true);
}

ObjectImpl<CheckerComponent>::~ObjectImpl()
{ }

void ObjectImpl<CheckerComponent>::SetField(int id, const Value& value, bool suppress_events, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::SetField(id, value, suppress_events, cookie); return; }
	switch (real_id) {
		case 0:
			SetConcurrentChecks(value, suppress_events, cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Value ObjectImpl<CheckerComponent>::GetField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::GetField(id); }
	switch (real_id) {
		case 0:
			return GetConcurrentChecks();
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<CheckerComponent>::ValidateField(int id, const Lazy<Value>& lvalue, const ValidationUtils& utils)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::ValidateField(id, lvalue, utils); return; }
	switch (real_id) {
		case 0:
			ValidateConcurrentChecks(lvalue, utils);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

void ObjectImpl<CheckerComponent>::NotifyField(int id, const Value& cookie)
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { ConfigObject::NotifyField(id, cookie); return; }
	switch (real_id) {
		case 0:
			NotifyConcurrentChecks(cookie);
			break;
		default:
			throw std::runtime_error("Invalid field ID.");
	}
}

Object::Ptr ObjectImpl<CheckerComponent>::NavigateField(int id) const
{
	int real_id = id - ConfigObject::TypeInstance->GetFieldCount(); 
	if (real_id < 0) { return ConfigObject::NavigateField(id); }
	throw std::runtime_error("Invalid field ID.");
}

int ObjectImpl<CheckerComponent>::GetConcurrentChecks() const
{
	return m_ConcurrentChecks.load();
}

void ObjectImpl<CheckerComponent>::SetConcurrentChecks(int value, bool suppress_events, const Value& cookie)
{
	m_ConcurrentChecks.store(value);
	if (!suppress_events) {
		NotifyConcurrentChecks(cookie);
	}

}

void ObjectImpl<CheckerComponent>::NotifyConcurrentChecks(const Value& cookie)
{
	auto *dobj = dynamic_cast<ConfigObject *>(this);
	if (!dobj || dobj->IsActive())
		OnConcurrentChecksChanged(static_cast<CheckerComponent *>(this), cookie);
}

int ObjectImpl<CheckerComponent>::GetDefaultConcurrentChecks() const
{
	return int();
}


boost::signals2::signal<void (const intrusive_ptr<CheckerComponent>&, const Value&)> ObjectImpl<CheckerComponent>::OnConcurrentChecksChanged;

void ObjectImpl<CheckerComponent>::ValidateConcurrentChecks(const Lazy<int>& lvalue, const ValidationUtils& utils)
{
	SimpleValidateConcurrentChecks(lvalue, utils);
}

}
#ifdef _MSC_VER
#pragma warning ( pop )
#endif /* _MSC_VER */
